package ${callbackPackage};

import cn.quantgroup.cashloanflow.entity.cashloanflow.LoanOrderMapping;
import cn.quantgroup.cashloanflow.entity.cashloanflow.UserMapping;
import cn.quantgroup.cashloanflow.model.standard.response.credit.QueryCreditStatusResponseModel;
import cn.quantgroup.cashloanflow.util.DateUtil;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import ${enumsPackage}.${prefix}CreditResultEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
* 授信结果回调
*
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
@Data
public class ${prefix}QueryCreditApplyCallback {



    private String channelUserId;

    private String channelOrderNo;

    private String applyNo;

    private ${prefix}CreditResultEnum creditResult;
    /**
    * 授信总金额(元)
    */
    private BigDecimal creditAmount;
    /**
    * 授信剩余可用额度(元)
    */
    private BigDecimal creditAvailable;
    /**
    * 分期规则,还款方式分期(REPAYMENT_METHOD)
    */
    private String termLabelsRule;

    private List<${prefix}RepaymentMethodTermLabel> repaymentMethodTermLabels;
    /**
    * 授信额度失效日期如:"2020-03-05"
    */
    private String limitExpireDate;
    /**
    * 用户授信情况描述，若”授信拒绝“则显示拒绝原因
    */
    private String creditInfo;
    /**
    * 下次申请时间（如yyyy-MM-dd）,如果额度申请结果为拒绝需要提供
    */
    private String nextApplyTime;


    public static ${prefix}QueryCreditApplyCallback getSuccessResult(LoanOrderMapping orderMapping, UserMapping userMapping, QueryCreditStatusResponseModel info) {
        ${prefix}QueryCreditApplyCallback result = new ${prefix}QueryCreditApplyCallback();

        result.setChannelUserId(userMapping.getChannelUserId());
        result.setChannelOrderNo(orderMapping.getChannelOrderNo());
        result.setApplyNo(orderMapping.getApplyNo());
        result.setCreditResult(${prefix}CreditResultEnum.CREDIT_NORMAL);
        result.setCreditAmount(StringUtils.isBlank(info.getApprovalAmount()) ? BigDecimal.ZERO : new BigDecimal(info.getApprovalAmount()));
        result.setCreditAvailable(StringUtils.isBlank(info.getApprovalAmount()) ? BigDecimal.ZERO : new BigDecimal(info.getApprovalAmount()));
        result.setTermLabelsRule("REPAYMENT_METHOD");
        List<${prefix}RepaymentMethodTermLabel> list = new ArrayList<>();
        ${prefix}RepaymentMethodTermLabel methodTermLabel = new ${prefix}RepaymentMethodTermLabel();
        methodTermLabel.setTermLabelsRuleValue("EQUAL_RENT");
        String monthlyInterestRate = info.getMonthlyInterestRate();
        methodTermLabel.setDailyRate(StringUtils.isBlank(monthlyInterestRate) ? BigDecimal.ZERO : new BigDecimal(monthlyInterestRate).divide(new BigDecimal("30"), 4, BigDecimal.ROUND_HALF_UP));
        methodTermLabel.setMonthlyRate(StringUtils.isBlank(monthlyInterestRate) ? BigDecimal.ZERO : new BigDecimal(monthlyInterestRate).setScale(4, BigDecimal.ROUND_HALF_UP));
        methodTermLabel.setYearlyRate(StringUtils.isBlank(monthlyInterestRate) ? BigDecimal.ZERO : new BigDecimal(monthlyInterestRate).multiply(new BigDecimal("12")).setScale(4, BigDecimal.ROUND_HALF_UP));
        methodTermLabel.setLoanTerm(info.getApprovalTerm());
        list.add(methodTermLabel);
        result.setRepaymentMethodTermLabels(list);
        result.setLimitExpireDate(DateUtil.format(info.getValidDate(), DateUtil.YYYY_MM_DD));
        return result;

    }
}