package ${eventhandlerPackage};



import cn.quantgroup.cashloanflow.entity.cashloanflow.LoanMapping;
import cn.quantgroup.cashloanflow.entity.cashloanflow.LoanOrderMapping;
import cn.quantgroup.cashloanflow.entity.cashloanflow.RepayFlowNoMapping;
import cn.quantgroup.cashloanflow.entity.cashloanflow.UserMapping;
import cn.quantgroup.cashloanflow.model.callback.KANoticeType;
import cn.quantgroup.cashloanflow.model.standard.response.credit.QueryCreditStatusResponseModel;
import cn.quantgroup.cashloanflow.model.xyqbmq.QuotaNoticeExtraDto;
import cn.quantgroup.cashloanflow.model.xyqbmq.QuotaRefuseNoticeExtraData;
import cn.quantgroup.cashloanflow.repository.cashloanflow.IRepayFlowNoMappingRepository;
import cn.quantgroup.cashloanflow.service.cashloanflow.ILoanOrderMappingService;
import cn.quantgroup.cashloanflow.service.cashloanflow.IUserMappingService;
import cn.quantgroup.cashloanflow.service.cashloanflow.LoanMappingService;
import cn.quantgroup.cashloanflow.util.DateUtil;
import cn.quantgroup.clf.util.JSONTools;
import cn.quantgroup.loanflow.application.StandardApplicationService;
import cn.quantgroup.loanflow.asynctask.executor.config.BizAppId;
import cn.quantgroup.loanflow.asynctask.model.AsyncTask;
import cn.quantgroup.loanflow.asynctask.model.HttpTaskBody;
import cn.quantgroup.loanflow.exception.CommonBizException;
import cn.quantgroup.loanflow.infrastructure.result.ServiceResult;
import cn.quantgroup.loanflow.notified.event.model.*;
import cn.quantgroup.loanflow.notified.handler.AbstractEventHandler;
import cn.quantgroup.loanflow.notified.handler.IEventHandler;
import cn.quantgroup.loanflow.notified.model.QueueNotice;
import cn.quantgroup.loanflow.order.model.ChannelOrder;
import cn.quantgroup.loanflow.repay.model.RepaymentPlanItem;
import cn.quantgroup.loanflow.repay.model.representation.OrderRepaymentRepresentation;
import cn.quantgroup.mo.risk.service.MoRiskRepresentationService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;


/**
*
* ${prefix} 渠道通知处理
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
@Service
@Slf4j
public class ${prefix}EventHandler extends AbstractEventHandler implements IEventHandler {
    @Autowired
    private ILoanOrderMappingService orderMappingService;
    @Autowired
    private IUserMappingService userMappingService;
    @Autowired
    private MoRiskRepresentationService moRiskRepresentationService;
    @Autowired
    private LoanMappingService loanMappingService;
    @Autowired
    private IRepayFlowNoMappingRepository repayFlowNoMappingRepository;

    @Resource(name = "standardApplicationMoService")
    private StandardApplicationService standardApplicationService;


    @Override
    public void creditSuccessPublish(CreditSuccessEvent creditSuccEvent) {
        String logPrefix = "[notify][handler][creditSuccEvent]";
        log.info("{},不处理进件同步成功事件,消息内容:{}", logPrefix, creditSuccEvent);
    }

    @Override
    public void auditRejectPublish(AuditRejectEvent auditRejectEvent) {
        String logPrefix = "[${prefix}EventHandler][auditRejectPublish]";
        log.info("{},${prefix},审核拒绝事件,消息内容:{}", logPrefix, auditRejectEvent);
        QuotaNoticeExtraDto extraDto = auditRejectEvent.getQueueNotice();
        Long channelId = auditRejectEvent.getChannelId();
        KANoticeType noticeType = auditRejectEvent.getNoticeType();
        String applyNo = extraDto.getData().getApplyNo();
        String channelOrderNo = auditRejectEvent.getChannelOrderNo();
        Long nextApplyTime = auditRejectEvent.getNextApplyTime();
        String reason = auditRejectEvent.getReason();

        String callbackUrl = getOrderCallbackUrl(channelId, noticeType);
        if (StringUtils.isEmpty(callbackUrl)) {
            log.error("{},回调地址无配置,channelId:{},applyNo:{},noticeType:{}", logPrefix, channelId, applyNo, noticeType.name());
            throw new CommonBizException("回调地址无配置");
        }

        LoanOrderMapping orderMapping = getOrderMapping(channelOrderNo, channelId);
        Long userId = orderMapping.getQgUserId();

        UserMapping userMapping = getUserMapping(userId, channelId);
        String channelUserId = userMapping.getChannelUserId();

        Map<String, String> callbackParam = new HashMap<>();
        QueueNotice queueNotice = new QueueNotice(noticeType, extraDto);
        publishTask(callbackParam, callbackUrl, queueNotice);
    }

    @Override
    public void auditPassPublish(AuditPassEvent auditPassEvent) {
        String logPrefix = "[${prefix}EventHandler][auditPassPublish]";
        log.info("{},审核通过事件,消息内容:{}", logPrefix, auditPassEvent);
        QuotaNoticeExtraDto extraDto = auditPassEvent.getQueueNotice();
        Long channelId = auditPassEvent.getChannelId();
        KANoticeType noticeType = auditPassEvent.getNoticeType();
        String applyNo = extraDto.getData().getApplyNo();
        String channelOrderNo = auditPassEvent.getChannelOrderNo();

        String callbackUrl = getOrderCallbackUrl(channelId, noticeType);
        if (StringUtils.isEmpty(callbackUrl)) {
            log.error("{},回调地址无配置,channelId:{},applyNo:{},noticeType:{}", logPrefix, channelId, applyNo, noticeType.name());
            throw new CommonBizException("回调地址无配置");
        }

        LoanOrderMapping orderMapping = getOrderMapping(channelOrderNo, channelId);
        Long userId = orderMapping.getQgUserId();

        UserMapping userMapping = getUserMapping(userId, channelId);
        String channelUserId = userMapping.getChannelUserId();

        ChannelOrder channelOrderQueryCreditStatus = ChannelOrder.builder()
            .channelOrderNo(channelOrderNo)
            .channelId(channelId)
            .build();
        ServiceResult<QueryCreditStatusResponseModel> creditStatus = standardApplicationService.queryCreditStatus(channelOrderQueryCreditStatus);

        log.info("{} 授信结果查询返回信息 creditStatus={}，orderNo={}", logPrefix, creditStatus, channelOrderNo);
        QueryCreditStatusResponseModel creditInfo;
        if (Objects.isNull(creditStatus) || !creditStatus.isSuccess() || Objects.isNull(creditInfo = creditStatus.getData())) {
            log.error("{},审批通过推送,查询授信结果失败或无数据,orderNo={},applyNo={}", logPrefix, channelOrderNo, applyNo);
            throw new CommonBizException("审批推送,查询授信结果失败或无数据");
        }


        Map<String, String> callbackParam = new HashMap<>();
        QueueNotice queueNotice = new QueueNotice(noticeType, extraDto);

        publishTask(callbackParam, callbackUrl, queueNotice);
    }


    @Override
    public void withdrawPublish(WithdrawEvent withdrawEvent) {
        String logPrefix = "[${prefix}EventHandler][withdrawPublish]";
        log.info("{},不处理申请提现成功事件,消息内容:{}", logPrefix, withdrawEvent);
    }

    @Override
    public void fundSuccessPublish(FundSuccessEvent fundSuccessEvent) {
        String logPrefix = "[${prefix}EventHandler][fundSuccessPublish]";
        log.info("{},放款成功事件,消息内容:{}", logPrefix, fundSuccessEvent);
        QuotaNoticeExtraDto extraDto = fundSuccessEvent.getQueueNotice();
        Long channelId = fundSuccessEvent.getChannelId();
        Long loanId = fundSuccessEvent.getLoanId();
        KANoticeType noticeType = fundSuccessEvent.getNoticeType();
        String applyNo = extraDto.getData().getApplyNo();
        String channelOrderNo = fundSuccessEvent.getChannelOrderNo();

        String callbackUrl = getOrderCallbackUrl(channelId, noticeType);
        if (StringUtils.isEmpty(callbackUrl)) {
            log.error("{},回调地址无配置,channelId:{},applyNo:{},noticeType:{}", logPrefix, channelId, applyNo, noticeType.name());
            throw new CommonBizException("回调地址无配置");
        }

        LoanOrderMapping orderMapping = getOrderMapping(channelOrderNo, channelId);
        Long userId = orderMapping.getQgUserId();

        UserMapping userMapping = getUserMapping(userId, channelId);
        String channelUserId = userMapping.getChannelUserId();

        LoanMapping loanMapping = loanMappingService.findByLoanIdAndChannelId(loanId, channelId);
        if (Objects.isNull(loanMapping)) {
            log.error("{}通过loanId查询LoanMapping为空, loanId={}, channelId={}", logPrefix, loanId, channelId);
            throw new CommonBizException("通过loanId查询LoanMapping为空");
        }

        String channelLoanNo = loanMapping.getChannelLoanNo();

        Map<String, String> callbackParam = new HashMap<>();
        QueueNotice queueNotice = new QueueNotice(noticeType, extraDto);

        publishTask(callbackParam, callbackUrl, queueNotice);


    }

    @Override
    public void fundFailPublish(FundFailEvent fundFailEvent) {
        String logPrefix = "[${prefix}EventHandler][fundFailPublish]";
        log.info("{},放款失败事件,消息内容:{}", logPrefix, fundFailEvent);
        QuotaNoticeExtraDto extraDto = fundFailEvent.getQueueNotice();
        Long channelId = fundFailEvent.getChannelId();
        Long loanId = fundFailEvent.getLoanId();
        KANoticeType noticeType = fundFailEvent.getNoticeType();
        String applyNo = extraDto.getData().getApplyNo();
        String channelOrderNo = fundFailEvent.getChannelOrderNo();
        Long changeTime = fundFailEvent.getChangeTime();
        String reason = fundFailEvent.getReason();

        String callbackUrl = getOrderCallbackUrl(channelId, noticeType);
        if (StringUtils.isEmpty(callbackUrl)) {
            log.error("{},回调地址无配置,channelId:{},applyNo:{},noticeType:{}", logPrefix, channelId, applyNo, noticeType.name());
            throw new CommonBizException("回调地址无配置");
        }
        LoanOrderMapping orderMapping = getOrderMapping(channelOrderNo, channelId);
        Long userId = orderMapping.getQgUserId();

        UserMapping userMapping = getUserMapping(userId, channelId);
        String channelUserId = userMapping.getChannelUserId();

        LoanMapping loanMapping = loanMappingService.findByLoanIdAndChannelId(loanId, channelId);
        if (Objects.isNull(loanMapping)) {
            log.error("{}通过loanId查询LoanMapping为空, loanId={}, channelId={}", logPrefix, loanId, channelId);
            throw new CommonBizException("通过loanId查询LoanMapping为空");
        }

        String channelLoanNo = loanMapping.getChannelLoanNo();

        Map<String, String> callbackParam = new HashMap<>();
        QueueNotice queueNotice = new QueueNotice(noticeType, extraDto);
        publishTask(callbackParam, callbackUrl, queueNotice);

    }

    @Override
    public void cancelLoanPublish(CancelLoanEvent cancelLoanEvent) {
        String logPrefix = "[${prefix}EventHandler][cancelLoanPublish]";
        log.info("{},贷前关单事件,消息内容:{}", logPrefix, cancelLoanEvent);
        QuotaNoticeExtraDto extraDto = cancelLoanEvent.getQueueNotice();
        Long channelId = cancelLoanEvent.getChannelId();
        String channelOrderNo = cancelLoanEvent.getChannelOrderNo();
        Long closeTime = cancelLoanEvent.getChangeTime();
        KANoticeType noticeType = cancelLoanEvent.getNoticeType();
        String applyNo = extraDto.getData().getApplyNo();

        String callbackUrl = getOrderCallbackUrl(channelId, noticeType);
        if (StringUtils.isEmpty(callbackUrl)) {
            log.error("{},回调地址无配置,channelId:{},applyNo:{},noticeType:{}", logPrefix, channelId, applyNo, noticeType.name());
            throw new CommonBizException("回调地址无配置");
        }

        LoanOrderMapping orderMapping = getOrderMapping(channelOrderNo, channelId);
        Long userId = orderMapping.getQgUserId();

        UserMapping userMapping = getUserMapping(userId, channelId);
        String channelUserId = userMapping.getChannelUserId();

        Map<String, String> callbackParam = new HashMap<>();
        QueueNotice queueNotice = new QueueNotice(noticeType, extraDto);
        publishTask(callbackParam, callbackUrl, queueNotice);

    }


    @Override
    public void settleUpPublish(SettleUpEvent settleUpEvent) {
        String logPrefix = "[${prefix}EventHandler][settleUpPublish]";
        log.info("{},结清事件,消息内容:{}", logPrefix, settleUpEvent);
        QuotaNoticeExtraDto extraDto = settleUpEvent.getQueueNotice();
        Long channelId = settleUpEvent.getChannelId();
        String channelOrderNo = settleUpEvent.getChannelOrderNo();
        Long changeTime = settleUpEvent.getChangeTime();
        KANoticeType noticeType = settleUpEvent.getNoticeType();
        Long loanId = settleUpEvent.getLoanId();
        String applyNo = extraDto.getData().getApplyNo();

        String callbackUrl = getOrderCallbackUrl(channelId, noticeType);
        if (StringUtils.isEmpty(callbackUrl)) {
            log.error("{},回调地址无配置,channelId:{},loanId:{},noticeType:{}", logPrefix, channelId, loanId, noticeType.name());
            throw new CommonBizException("回调地址无配置");
        }

        LoanOrderMapping orderMapping = getOrderMapping(channelOrderNo, channelId);
        Long userId = orderMapping.getQgUserId();

        UserMapping userMapping = getUserMapping(userId, channelId);
        String channelUserId = userMapping.getChannelUserId();

        Map<String, String> callbackParam = new HashMap<>();
        QueueNotice queueNotice = new QueueNotice(noticeType, extraDto);
        publishTask(callbackParam, callbackUrl, queueNotice);

        processSettleUp(settleUpEvent);
    }


    @Override
    public void repaySuccessPublish(RepaySuccessEvent repaySuccessEvent) {
        String logPrefix = "[${prefix}EventHandler][repaySuccessPublish]";
        log.info("{},还款成功事件,消息内容:{}", logPrefix, repaySuccessEvent);
        QuotaNoticeExtraDto extraDto = repaySuccessEvent.getQueueNotice();
        Long channelId = repaySuccessEvent.getChannelId();
        Long loanId = repaySuccessEvent.getLoanId();
        KANoticeType noticeType = repaySuccessEvent.getNoticeType();
        String applyNo = extraDto.getData().getApplyNo();
        String channelOrderNo = repaySuccessEvent.getChannelOrderNo();
        String businessFlowNo = repaySuccessEvent.getBusinessFlowNo();

        String callbackUrl = getOrderCallbackUrl(channelId, noticeType);
        if (StringUtils.isEmpty(callbackUrl)) {
            log.error("{},回调地址无配置,channelId:{},applyNo:{},noticeType:{}", logPrefix, channelId, applyNo, noticeType.name());
            throw new CommonBizException("回调地址无配置");
        }

        LoanOrderMapping orderMapping = getOrderMapping(channelOrderNo, channelId);
        Long userId = orderMapping.getQgUserId();

        UserMapping userMapping = getUserMapping(userId, channelId);
        String channelUserId = userMapping.getChannelUserId();

        // 查询借据信息
        LoanMapping loanMapping = loanMappingService.findByLoanIdAndChannelId(loanId, channelId);
        if (Objects.isNull(loanMapping)) {
            log.error("{}通过loanId查询LoanMapping为空, loanId={}, channelId={}", logPrefix, loanId, channelId);
            throw new CommonBizException("通过loanId查询LoanMapping为空");
        }
        String channelLoanNo = loanMapping.getChannelLoanNo();
        // 查询渠道的还款流水号
        String channelRepaymentNo = null;
        BigDecimal repaymentAmount = null;
        RepayFlowNoMapping repayFlowNoMapping = repayFlowNoMappingRepository.findByXyqbRepayFlowNoOne(businessFlowNo);
        if (Objects.nonNull(repayFlowNoMapping)) {
            channelRepaymentNo = repayFlowNoMapping.getChannelRepayFlowNo();
            repaymentAmount = new BigDecimal(repayFlowNoMapping.getRepayAmount());
        }
        // 查询还款计划
        ServiceResult<OrderRepaymentRepresentation> serviceResult = standardApplicationService.repaymentPlanQueryByCycleQuota(loanId);
        log.info("{} 查询还款计划结果 serviceResult={}，orderNo={}", logPrefix, serviceResult, channelOrderNo);

        if (Objects.isNull(serviceResult) || !serviceResult.isSuccess() || Objects.isNull(serviceResult.getData())) {
            log.error("{},还款成功推送,查询还款计划返回错误或无数据,orderNo={},applyNo={}", logPrefix, channelOrderNo, applyNo);
            throw new CommonBizException("还款成功,查询还款计划返回错误或无数据");
        }
        List<RepaymentPlanItem> repaymentPlans = serviceResult.getData().getRepaymentPlans();

        Map<String, String> callbackParam = new HashMap<>();
        QueueNotice queueNotice = new QueueNotice(noticeType, extraDto);
        publishTask(callbackParam, callbackUrl, queueNotice);
        super.processRepay(repaySuccessEvent.getQueueNotice());
    }

    @Override
    public void repayFailPublish(RepayFailEvent repayFailEvent) {
        String logPrefix = "[${prefix}EventHandler][repayFailPublish]";
        log.info("{},还款失败事件,消息内容:{}", logPrefix, repayFailEvent);
        QuotaNoticeExtraDto extraDto = repayFailEvent.getQueueNotice();
        String businessFlowNo = repayFailEvent.getBusinessFlowNo();
        String failMsg = repayFailEvent.getFailMsg();
        String channelOrderNo = repayFailEvent.getChannelOrderNo();
        Long channelId = repayFailEvent.getChannelId();
        KANoticeType noticeType = repayFailEvent.getNoticeType();
        String applyNo = extraDto.getData().getApplyNo();

        String callbackUrl = getOrderCallbackUrl(channelId, noticeType);
        if (StringUtils.isEmpty(callbackUrl)) {
            log.error("{},回调地址无配置,channelId:{},applyNo:{},noticeType:{}", logPrefix, channelId, applyNo, noticeType.name());
            throw new CommonBizException("回调地址无配置");
        }

        LoanOrderMapping orderMapping = getOrderMapping(channelOrderNo, channelId);
        Long userId = orderMapping.getQgUserId();

        UserMapping userMapping = getUserMapping(userId, channelId);
        String channelUserId = userMapping.getChannelUserId();

        // 根据核心系统还款流水号查询渠道的还款流水号
        String channelRepayFlowNo = null;
        BigDecimal repaymentAmount = null;
        RepayFlowNoMapping repayFlowNoMapping = repayFlowNoMappingRepository.findByXyqbRepayFlowNoOne(businessFlowNo);
        if (Objects.nonNull(repayFlowNoMapping)) {
            channelRepayFlowNo = repayFlowNoMapping.getChannelRepayFlowNo();
            repaymentAmount = new BigDecimal(repayFlowNoMapping.getRepayAmount());
        }

        Map<String, String> callbackParam = new HashMap<>();
        QueueNotice queueNotice = new QueueNotice(noticeType, extraDto);
        publishTask(callbackParam, callbackUrl, queueNotice);
        super.processRepay(repayFailEvent.getQueueNotice());
    }


    @Override
    public void cancelAfterLoanPublish(CancelAfterLoanEvent cancelAfterLoanEvent) {
        String logPrefix = "[${prefix}EventHandler][cancelAfterLoanPublish]";
        log.info("{},不处理贷后关单事件,消息内容:{}", logPrefix, cancelAfterLoanEvent);

    }

    @Override
    public void dropCourseSuccessPublish(DropCourseSuccessEvent dropCourseSuccEvent) {
        String logPrefix = "[${prefix}EventHandler][dropCourseSuccessPublish]";
        log.info("{},不处理退课事件,消息内容:{}", logPrefix, dropCourseSuccEvent);
    }

    @Override
    public void addBankCardPublish(AddBankCardEvent addBankCardEvent) {
        String logPrefix = "[${prefix}EventHandler][addBankCardEvent]";
        log.info("{},不处理添加卡事件,消息内容:{}", logPrefix, addBankCardEvent);
    }

    @Override
    public void bindCardPublish(BindCardEvent bindCardEvent) {
        String logPrefix = "[${prefix}EventHandler][bindCardEvent]";
        log.info("{},不处理绑卡事件,消息内容:{}", logPrefix, bindCardEvent);
    }

    /**
    * 根据channelOrderNo,channelId 查询出渠道授信订单
    *
    * @param channelOrderNo
    * @param channelId
    * @return
    */
    private LoanOrderMapping getOrderMapping(String channelOrderNo, Long channelId) {
        LoanOrderMapping orderMapping = orderMappingService.findByChannelOrderNoAndRegisteredFromLastOne(channelOrderNo, channelId);
        if (Objects.isNull(orderMapping)) {
            log.error("${prefix}渠道回调通知，查询授信订单为空, channelOrderNo={}, channelId={}", channelOrderNo, channelId);
            throw new CommonBizException("查询授信订单为空");
        }
        return orderMapping;
    }


    /**
    * 根据userId,channelId 查询UserMapping
    *
    * @param userId
    * @param channelId
    * @return
    */
    private UserMapping getUserMapping(Long userId, Long channelId) {
        UserMapping userMapping = userMappingService.findByQgUserIdAndRegisteredFrom(userId, channelId);
        if (Objects.isNull(userMapping)) {
            log.error("${prefix}渠道回调通知，通过qgUserId查询渠道用户id为空, qgUserId={}, channelId={}", userId, channelId);
            throw new CommonBizException("通过qgUserId查询渠道用户id为空");
        }
        return userMapping;
    }

    /**
    * 发布任务
    *
    * @param paraMap
    * @param url
    * @param queueNotice
    */
    private void publishTask(Map<String, String> paraMap, String url, QueueNotice queueNotice) {
        log.info("[publishTask],发送消息内容:{},url地址:{},ka消息体:{}", paraMap, url, queueNotice);
        HttpTaskBody taskBody = this.buildTaskBody(paraMap, url, queueNotice);
        log.info("[publishTask],taskBody:{}", taskBody);
        AsyncTask asyncTask = super.buildPublishTask(BizAppId.CHANNEL_NOTIFY, queueNotice);
        log.info("[publishTask],asyncTask:{}", asyncTask);
        asyncTask.setTaskBody(taskBody);
        super.publishAsyncTask(asyncTask, queueNotice);
    }

    /**
    * 构建推送TaskBody
    *
    * @param paraMap
    * @param url
    * @param queueNotice
    * @return
    */
    private HttpTaskBody buildTaskBody(Map<String, String> paraMap, String url, QueueNotice queueNotice) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("", "");
        String assetRule = jsonObject.toJSONString();

        Map<String, String> header = new HashMap<>(2);
        header.put("Content-Type", "");
        HttpTaskBody taskBody = new HttpTaskBody();
        taskBody.setHeaders(header);
        taskBody.setUrl(url);
        taskBody.setParams(paraMap);
        taskBody.setAssertRule(assetRule);
        taskBody.setQueueNotice(queueNotice);
        return taskBody;
    }


}
