package ${modelPackage};


import cn.quantgroup.cashloanflow.util.DateUtil;
import cn.quantgroup.cashloanflow.util.RegisterFrom;
import cn.quantgroup.loanflow.order.model.OrderStatus;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
/**
* 查询还款结果入参
*
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
@Data
@Slf4j
public class ${prefix}QueryLoanResult {

    private String loanApplyStatus;
    private String applyResult;
    private String loanQueryTransNo;

    public ${prefix}QueryLoanResult(OrderStatus orderStatus) {
        this.loanQueryTransNo = RegisterFrom.JINSHAN.getValue() + DateUtil.get13LongTimeFormLong();
        log.info("借款申请的结果返回的查询交易流水号={}", loanQueryTransNo);
        switch (orderStatus.getStatus()) {
            case WITHDRAW:
            case PAY_ING:
                this.loanApplyStatus = "APPLYING";
                break;
            case FUND_SUCC:
            case ALL_REPAID:
                this.loanApplyStatus = "SUCCESS";
                break;
            case FUND_FAIL:
                this.loanApplyStatus = "FAIL";
                break;
            default:
                break;
        }
    }

}