package ${callbackPackage};

import cn.quantgroup.cashloanflow.entity.cashloanflow.UserMapping;
import cn.quantgroup.cashloanflow.model.xyqbmq.QuotaNoticeExtraDto;
import cn.quantgroup.loanflow.notified.event.model.RepaySuccessEvent;
import cn.quantgroup.loanflow.repay.model.RepaymentPlanItem;
import lombok.Data;
import ${enumsPackage}.${prefix}RepayStatusEnum;
import ${enumsPackage}.${prefix}RepayTypeEnum;
import cn.quantgroup.cashloanflow.service.callback.loan.state.guomei.RepaymentType;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
* 还款回调
*
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
@Data
public class ${prefix}QueryRepayCallback {

    private String channelUserId;
    private String businessFlowNo;
    private String channelRepayFlowNo;
    private BigDecimal repaymentAmount;
    private ${prefix}RepayStatusEnum repayStatus;
    private String failMsg;
    private String failCode;
    private ${prefix}RepayTypeEnum repayType;
    /**
    * 实际还款时间(金额实际到账的时间,精确到时分秒) 格式如：yyyy-MM-dd HH:mm:ss 成功的时候必填
    */
    private String actualTime;

    private List<${prefix}ContractInfoNotice> contractList;


    public static ${prefix}QueryRepayCallback getSuccessResult(String channelUserId, RepaySuccessEvent repaySuccessEvent, String channelLoanNo, String channelRepayFlowNo, List<RepaymentPlanItem> repaymentPlans) {
        Long loanId = repaySuccessEvent.getLoanId();
        String xyqbRepayFlowNo = repaySuccessEvent.getBusinessFlowNo();
        BigDecimal actualRepayment = repaySuccessEvent.getActualRepayment();
        String repaymentReceivedAt = repaySuccessEvent.getRepaymentReceivedAt();

        ${prefix}QueryRepayCallback callback = new ${prefix}QueryRepayCallback();

        callback.setChannelUserId(channelUserId);
        callback.setChannelRepayFlowNo(channelRepayFlowNo);
        callback.setBusinessFlowNo(xyqbRepayFlowNo);
        callback.setRepaymentAmount(actualRepayment);
        callback.setRepayStatus(${prefix}RepayStatusEnum.SUCCESS);
        callback.setActualTime(repaymentReceivedAt);
        callback.setRepayType(getRepayType(repaySuccessEvent.getRepayType()));
        List<${prefix}ContractInfoNotice> contractInfoNotices = new ArrayList<>();
        ${prefix}ContractInfoNotice notice = new ${prefix}ContractInfoNotice();
        notice.setChannelLoanNo(channelLoanNo);
        notice.setLoanNo(String.valueOf(loanId));
        List<${prefix}InoutPlanNotice> inoutPlanNotices = new ArrayList<>();
        repaymentPlans.forEach(i -> {
            ${prefix}InoutPlanNotice planNotice = new ${prefix}InoutPlanNotice();
            planNotice.setLeaseTime(i.getPeriodNo());
            planNotice.setReceivedCorpus(i.getActPrincipal());
            planNotice.setReceivedInterest(i.getActInterest());
            planNotice.setReceivedFine(i.getActOverdueInterest());
            planNotice.setReceivedTotalAmount(i.getRepayAmount());
            planNotice.setExtraFee(i.getActServiceFee());
            planNotice.setReceivedInterestRate(BigDecimal.ZERO);

            inoutPlanNotices.add(planNotice);
        });
        notice.setInoutPlanList(inoutPlanNotices);
        contractInfoNotices.add(notice);
        callback.setContractList(contractInfoNotices);
        return callback;
    }

    private static ${prefix}RepayTypeEnum getRepayType(RepaymentType koalaRepay) {
        switch (koalaRepay){
            case COMMON:
                return ${prefix}RepayTypeEnum.ACTIVE;
            case OFFLINE_REPAY:
                return ${prefix}RepayTypeEnum.OFFLINE;
            case SELF_WITHHOLD:
                return ${prefix}RepayTypeEnum.BATCH;
            default: return ${prefix}RepayTypeEnum.OTHER;
        }
    }

}
