package cn.quantgroup.codegenerator.util;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Wang Xiangwei
 * @version 2020/6/1
 */
public class XmlParseUtil {


    public static Map<String, String> parseXml() throws Exception {


        Map<String,String> node = new HashMap<>();

        File xmlFile = new File(System.getProperty("user.dir"), "/src/main/resources/GenerateConf.xml");
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document doc = builder.parse(xmlFile);

        Element rootElement = doc.getDocumentElement(); //获取根元素
        Node author = rootElement.getElementsByTagName("author").item(0);
        String authorValue = author.getFirstChild().getNodeValue();
        node.put("author",authorValue);

        Node prefix = rootElement.getElementsByTagName("prefix").item(0);
        String prefixValue = prefix.getFirstChild().getNodeValue();
        node.put("prefix",prefixValue);

        Node model = rootElement.getElementsByTagName("model").item(0);
        String modelPath = ((Element) model).getAttribute("path");
        String modelPackage = ((Element) model).getElementsByTagName("packageName").item(0).getFirstChild().getNodeValue();

        node.put("modelPath",modelPath);
        node.put("modelPackage",modelPackage);

        Node util = rootElement.getElementsByTagName("util").item(0);
        String utilPath = ((Element) util).getAttribute("path");
        String utilPackage = ((Element) util).getElementsByTagName("packageName").item(0).getFirstChild().getNodeValue();

        node.put("utilPath",utilPath);
        node.put("utilPackage",utilPackage);


        Node enums = rootElement.getElementsByTagName("enums").item(0);
        String enumsPath = ((Element) enums).getAttribute("path");
        String enumsPackage = ((Element) enums).getElementsByTagName("packageName").item(0).getFirstChild().getNodeValue();

        node.put("enumsPath",enumsPath);
        node.put("enumsPackage",enumsPackage);


        Node callback = rootElement.getElementsByTagName("callback").item(0);
        String callbackPath = ((Element) callback).getAttribute("path");
        String callbackPackage = ((Element) callback).getElementsByTagName("packageName").item(0).getFirstChild().getNodeValue();

        node.put("callbackPath",callbackPath);
        node.put("callbackPackage",callbackPackage);


        Node service = rootElement.getElementsByTagName("service").item(0);
        String servicePath = ((Element) service).getAttribute("path");
        String servicePackage = ((Element) service).getElementsByTagName("packageName").item(0).getFirstChild().getNodeValue();

        node.put("servicePath",servicePath);
        node.put("servicePackage",servicePackage);

        Node eventHandler = rootElement.getElementsByTagName("eventHandler").item(0);
        String eventHandlerPath = ((Element) eventHandler).getAttribute("path");
        String eventHandlerPackage = ((Element) eventHandler).getElementsByTagName("packageName").item(0).getFirstChild().getNodeValue();
        node.put("eventhandlerPath",eventHandlerPath);
        node.put("eventhandlerPackage",eventHandlerPackage);

        return node;
    }

    public static void main(String[] args) {
        try {
            Map<String, String> stringStringMap = XmlParseUtil.parseXml();
            System.out.println(stringStringMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
