package ${enumsPackage};
import cn.quantgroup.cashloanflow.model.LoanDemandPurposeEnum;
import lombok.Getter;

/**
* 金山用户借款用途列表
* 枚举类型 purpose01："个人日常消费" ；purpose02："装修"；purpose03: "旅游"；purpose04: "医疗"；purpose05: "教育"；purpose100："其他消费".
*
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
public enum ${prefix}LoanPurposesEnum {
    /**
    * "个人日常消费"
    */
    purpose01("个人日常消费"),
    /**
    * "装修"
    */
    purpose02("装修"),
    /**
    * "旅游"
    */
    purpose03("旅游"),
    /**
    * "医疗"
    */
    purpose04("医疗"),
    /**
    * "教育"
    */
    purpose05("教育"),
    /**
    * "其他消费"
    */
    purpose100("其他消费");

    @Getter
    private String value;

    ${prefix}LoanPurposesEnum(String value) {
        this.value = value;
    }

    public static LoanDemandPurposeEnum getKoaLaPurpose(${prefix}LoanPurposesEnum loanPurposesEnum) {
        switch (loanPurposesEnum) {
            case purpose01:
                return LoanDemandPurposeEnum.PERSONAL_DAILY_CONSUMPTION;
            case purpose02:
                return LoanDemandPurposeEnum.FAMILY_DECORATION;
            case purpose03:
                return LoanDemandPurposeEnum.TOURIST_HOLIDAY;
            case purpose04:
                return LoanDemandPurposeEnum.HEALTH_CARE;
            case purpose05:
                return LoanDemandPurposeEnum.EDUCATION_AND_TRAINING;
            case purpose100:
                return LoanDemandPurposeEnum.PERSONAL_DAILY_CONSUMPTION;
            default:
                return LoanDemandPurposeEnum.PERSONAL_DAILY_CONSUMPTION;
        }
    }
}