package ${servicePackage};


import ${modelPackage}.${prefix}CreditApplyRequest;
import ${modelPackage}.${prefix}QueryCreditApplyResult;
import ${modelPackage}.${prefix}UserAccessRequest;
import ${modelPackage}.${prefix}QueryCreditApplyRequest;
import ${modelPackage}.${prefix}QuerySupportBankcardsRequest;
import ${modelPackage}.${prefix}QueryLoanTrialRequest;
import ${modelPackage}.${prefix}UserAccessResult;
import ${modelPackage}.${prefix}BindBankCardSmsRequest;
import ${modelPackage}.${prefix}CreditApplyResult;
import ${modelPackage}.${prefix}VerifyBindSmsRequest;
import ${modelPackage}.${prefix}ApplyLoanRequest;
import ${modelPackage}.${prefix}QueryLoanRequest;
import ${modelPackage}.${prefix}RepayByPlanRequest;
import ${modelPackage}.${prefix}QueryRepayRequest;
import ${modelPackage}.${prefix}CreditApplyRequest;
import ${utilPackage}.${prefix}CodeEnum;
import ${enumsPackage}.${prefix}LoanPurposesEnum;
import cn.quantgroup.loanflow.infrastructure.result.ServiceResult;
import cn.quantgroup.clf.util.ChannelUtils;
import cn.quantgroup.cashloanflow.model.standard.response.credit.CreditStatusEnum;
import cn.quantgroup.loanflow.application.model.ApplyLoanRequestData;
import cn.quantgroup.cashloanflow.entity.cashloanflow.LoanMapping;
import cn.quantgroup.cashloanflow.entity.cashloanflow.LoanOrderMapping;
import cn.quantgroup.cashloanflow.model.standard.apply.ApplyLoanCheckData;
import cn.quantgroup.cashloanflow.model.standard.response.credit.QueryCreditStatusResponseModel;
import cn.quantgroup.cashloanflow.model.xyqb.BusinessType;
import cn.quantgroup.cashloanflow.model.xyqb.orderstatus.OrderStatusEnums;
import cn.quantgroup.cashloanflow.repository.cashloanflow.ILoanOrderMappingRepository;
import cn.quantgroup.cashloanflow.service.cashloanflow.IChannelApplyInfoStrategyService;
import cn.quantgroup.cashloanflow.service.cashloanflow.ILoanOrderMappingService;
import cn.quantgroup.cashloanflow.service.cashloanflow.LoanMappingService;
import cn.quantgroup.cashloanflow.util.DateUtil;
import cn.quantgroup.cashloanflow.util.IpUtil;
import cn.quantgroup.cashloanflow.util.JsonUtil;
import cn.quantgroup.cashloanflow.util.loan.ProductUtil;

import cn.quantgroup.loanflow.exception.CommonBizException;
import cn.quantgroup.loanflow.application.StandardApplicationService;
import cn.quantgroup.loanflow.application.model.ApplyLoanData;
import cn.quantgroup.loanflow.infrastructure.code.UserCode;
import cn.quantgroup.loanflow.infrastructure.result.ServiceResult;
import cn.quantgroup.loanflow.order.model.BindCardConfirm;
import cn.quantgroup.loanflow.order.model.BindCardVerifyInfo;
import cn.quantgroup.loanflow.order.model.ChannelOrder;
import cn.quantgroup.loanflow.order.model.OrderStatus;
import cn.quantgroup.loanflow.order.model.command.BindCardCommand;
import cn.quantgroup.loanflow.order.model.command.BindCardVerifyCommand;
import cn.quantgroup.loanflow.order.model.command.WithDrawCommand;
import cn.quantgroup.loanflow.order.service.OrderRepresentationService;
import cn.quantgroup.loanflow.repay.model.RepaymentPlanItem;
import cn.quantgroup.loanflow.repay.model.command.NormalRepayCommand;
import cn.quantgroup.loanflow.repay.model.representation.OrderRepaymentRepresentation;
import cn.quantgroup.loanflow.repay.model.representation.QueryNormalRepayRepresentation;
import cn.quantgroup.loanflow.repay.model.representation.RepayResultRepresentation;
import cn.quantgroup.loanflow.repay.model.representation.TrialRepaymentRepresentation;
import cn.quantgroup.loanflow.risk.model.PretrialAuditQuery;
import cn.quantgroup.loanflow.risk.model.representation.PretrialAuditRepresentation;
import cn.quantgroup.loanflow.user.model.command.UserAddrImportCommand;
import cn.quantgroup.loanflow.user.model.command.UserBasicInfoImportCommand;
import cn.quantgroup.loanflow.user.model.command.UserContactImportCommand;
import cn.quantgroup.loanflow.user.model.command.UserExtInfoImportCommand;
import cn.quantgroup.loanflow.user.model.representation.SysUser;
import cn.quantgroup.loanflow.user.model.representation.SysUserDetail;
import cn.quantgroup.loanflow.user.service.UserDomainService;
import cn.quantgroup.mo.infrastructure.constants.RequestSourceEnum;
import cn.quantgroup.mo.order.model.WithdrawResult;
import cn.quantgroup.mo.order.model.output.MoBankCardInfoOutput;
import cn.quantgroup.mo.order.model.output.MoSimpleBank;
import cn.quantgroup.mo.order.service.MoOrderRepresentationService;
import cn.quantgroup.mo.risk.model.MoCreditOrder;
import cn.quantgroup.mo.risk.model.command.MoCreateCreditInfoCommand;
import cn.quantgroup.mo.risk.model.command.MoCreditConfirmInfoCommand;
import cn.quantgroup.mo.risk.model.command.MoImportRiskDataCommand;
import cn.quantgroup.mo.risk.service.MoRiskDomainService;
import cn.quantgroup.loanflow.asynctask.constant.AsyncTaskConstant;
import cn.quantgroup.loanflow.asynctask.executor.config.BizAppId;
import cn.quantgroup.loanflow.asynctask.model.ApplyLoanParam;
import cn.quantgroup.loanflow.asynctask.model.AsyncTask;
import cn.quantgroup.loanflow.asynctask.sender.DelaySender;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import cn.quantgroup.loanflow.application.apply.IAsyncApplyService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
@Service
@Slf4j
public class ${prefix}ServiceImpl implements ${prefix}Service{

    private static final String LOG_PRE = "[${prefix}ServiceImpl]";

    @Resource(name = "standardApplicationMoService")
    private StandardApplicationService standardApplicationService;
    @Autowired
    private MoOrderRepresentationService moOrderRepresentationService;
    @Autowired
    private HttpServletRequest httpServletRequest;
    @Autowired
    private LoanMappingService loanMappingService;
    @Autowired
    private ILoanOrderMappingService loanOrderMappingService;


    /**
    * 预审
    *
    * @param userAccessRequest
    * @return
    */
    @Override
    public ServiceResult<${prefix}UserAccessResult> userAccess(${prefix}UserAccessRequest userAccessRequest){
        String logPre = LOG_PRE + "[userAccess][${prefix}预审]";
        log.info("{} userAccessRequest={}",logPre,userAccessRequest);
        PretrialAuditQuery query = new PretrialAuditQuery();
        query.setChannelId(userAccessRequest.getChannelId());
        //手机号md5
        query.setPhoneNo(userAccessRequest.getPhoneMD5());
        //or 身份证号md5
        query.setIdCard(userAccessRequest.getIdNoMD5());
        //or md5(手机号+身份证号)
        query.setPhoneNo(userAccessRequest.getPhoneIdNoMD5());
        ServiceResult<PretrialAuditRepresentation> serviceResult = standardApplicationService.queryPretrialAudit(query);
        if (!serviceResult.isSuccess()) {
            log.error("{},错误{}", logPre, serviceResult.getMessage());
            throw new CommonBizException("调用预审服务异常");
        }
        PretrialAuditRepresentation pretrialAuditRepresentation = serviceResult.getData();

        ${prefix}UserAccessResult result = new ${prefix}UserAccessResult();
        return ServiceResult.success(result);
    }

    /**
    * 提交授信
    *
    * @param request
    * @return
    */
    @Override
    public ServiceResult<${prefix}CreditApplyResult> creditApply(${prefix}CreditApplyRequest request){
        String logPre = LOG_PRE +"[creditApply][授信申请]";
        log.info("{} request={}",logPre,request);
        ApplyLoanData applyLoanData = ${prefix}CreditApplyRequest.getApplyLoanData(request);
        ServiceResult<ApplyLoanRequestData> serviceResult = standardApplicationService.applyLoan(applyLoanData);
        if (!serviceResult.isSuccess()) {
            log.error("{},进件失败，result={}", logPre, serviceResult);
            throw new CommonBizException("调用进件服务异常");
        }
        ApplyLoanRequestData applyResult = serviceResult.getData();
        //授信订单号
        String applyNo = applyResult.getApplyNo();

        ${prefix}CreditApplyResult result = new ${prefix}CreditApplyResult();
        result.setApplyNo(applyNo);
        return ServiceResult.success(result);

    }




    /**
    * 授信申请结果主动查询
    *
    * @param request
    * @return
    */
    @Override
    public ServiceResult<${prefix}QueryCreditApplyResult> queryCreditApply(${prefix}QueryCreditApplyRequest request){
        String logPre = LOG_PRE + "[queryCreditApply][${prefix}查询授信结果]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        String channelOrderNo = request.getChannelOrderNo();
        ServiceResult<LoanOrderMapping> orderMappingServiceResult = moOrderRepresentationService.queryChannelOrderByOrderNoAndChannelId(channelOrderNo, channelId);
        if (!orderMappingServiceResult.isSuccess() || Objects.isNull(orderMappingServiceResult.getData())) {
            log.error("{}查询授信订单失败, result={}, request={}", logPre, orderMappingServiceResult, request);
            throw new CommonBizException("查询授信订单失败");
        }
        LoanOrderMapping orderMapping = orderMappingServiceResult.getData();
        LoanMapping loanMapping = loanMappingService.findByOrderMappingIdAndChannelId(orderMapping.getId(), channelId);
        String channelLoanNo = null;
        if (loanMapping != null) {
            channelLoanNo = loanMapping.getChannelLoanNo();
        }

        ServiceResult<OrderStatus> orderStatusServiceResult = standardApplicationService.queryOrderStatus(orderMapping.getChannelOrderNo(), channelLoanNo, channelId, null);
        if (!orderStatusServiceResult.isSuccess()) {
            log.error("{}，查询订单状态错误 , serviceResult={}, channelOrderNo={}", logPre, orderStatusServiceResult, orderMapping.getChannelOrderNo());
            throw new CommonBizException("查询订单状态错误");
        }
        OrderStatus orderStatus = orderStatusServiceResult.getData();
        OrderStatusEnums orderStatusEnums = orderStatusServiceResult.getData().getStatus();
        Long updateTime = orderStatus.getUpdateTime();
        if (ChannelUtils.finalStatus(orderStatusEnums)) {
        // 放款失败、关单、结清的订单情况
        }
        if (OrderStatusEnums.APPROVE_ING.equals(orderStatusEnums) || OrderStatusEnums.CREDIT_ORDER_SUBMITTING.equals(orderStatusEnums)) {
        // 审核中的情况
        }
        if (OrderStatusEnums.REJECT.equals(orderStatusEnums)) {
        // 审核拒绝的情况
        }
        String productId = ProductUtil.getProductId(channelId);
        ChannelOrder channelOrderQueryCreditStatus = ChannelOrder.builder()
                                                                 .channelOrderNo(channelOrderNo)
                                                                 .channelId(channelId)
                                                                 .build();
        ServiceResult<QueryCreditStatusResponseModel> creditStatusServiceResult = standardApplicationService.queryCreditStatus(channelOrderQueryCreditStatus);
        if (!creditStatusServiceResult.isSuccess()) {
            log.error("{}查询失败，serviceResult={}, userId={}, productId={}", logPre, creditStatusServiceResult, orderMapping.getQgUserId(), productId);
            throw new CommonBizException("查询授信订单状态服务异常");
        }

        QueryCreditStatusResponseModel queryCreditStatusResponse = creditStatusServiceResult.getData();
        String creditStatus = queryCreditStatusResponse.getCreditStatus();
        if (CreditStatusEnum.CANCEL_LOAN.getValue().equals(creditStatus)) {
         // 授信订单为取消的情况
        }


        ${prefix}QueryCreditApplyResult result = new ${prefix}QueryCreditApplyResult();
        return ServiceResult.success(result);


    }


    /**
    * 查询支持的银行列表
    *
    * @param request
    * @return
    */
    @Override
    public void querySupportBankcards(${prefix}QuerySupportBankcardsRequest request){
        String logPre = LOG_PRE + "[querySupportBankcards][${prefix}查询支持的银行列表]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        ChannelOrder channelOrder = ChannelOrder.builder()
            .channelId(channelId)
            .channelOrderNo(request.getChannelOrderNo())
            .build();
        ServiceResult<List<MoSimpleBank>> serviceResult = standardApplicationService.querySupportBank(channelOrder);
        if (!serviceResult.isSuccess()) {
            log.error("{},查询失败，result={} param={}", logPre, serviceResult,channelOrder);
            throw new CommonBizException("查询支持的银行列表服务异常");
        }
        List<MoSimpleBank> supportBankList = serviceResult.getData();

    }

    /**
    * 借款试算
    *
    * @param request
    * @return
    */
    @Override
    public void queryLoanTrial(${prefix}QueryLoanTrialRequest request){
        String logPre = LOG_PRE + "[queryLoanTrial][${prefix}查询试算数据]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        ChannelOrder channelOrder = ChannelOrder.builder()
            .channelOrderNo(request.getChannelOrderNo())
            .channelId(channelId)
            .build();
        ServiceResult<TrialRepaymentRepresentation> serviceResult = standardApplicationService.trialRepayment(channelOrder, request.getLoanAmount(), request.getLoanTerm());
        if (!serviceResult.isSuccess()) {
            log.error("{}失败，serviceResult={}，request={}", logPre, serviceResult, request);
            throw new CommonBizException("借款试算服务异常");
        }
        TrialRepaymentRepresentation trialRepaymentRepresentation = serviceResult.getData();

    }


    /**
    * 绑卡发验证码
    *
    * @param request
    * @return
    */
    @Override
    public void bindBankCardSms(${prefix}BindBankCardSmsRequest request){
        String logPre = LOG_PRE + "[bindBankCardSms][${prefix}绑卡发短信]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        BindCardCommand command = new BindCardCommand();
        command.setBankCode(request.getBankCode());
        command.setReservePhoneNumber(request.getPhone());
        command.setBankCardNumber(request.getBankCardNo());
        ServiceResult<BindCardVerifyInfo> serviceResult = standardApplicationService.bindCard(channelId, request.getChannelOrderNo(), command);
        if (!serviceResult.isSuccess()) {
            log.error("{}错误，serviceResult={}, request={}", logPre, serviceResult, request);
            throw new CommonBizException("绑卡服务异常");
        }
        BindCardVerifyInfo bindCardVerifyInfo = serviceResult.getData();

    }

    /**
    * 验卡
    *
    * @param request
    * @return
    */
    @Override
    public void verifyBindSms(${prefix}VerifyBindSmsRequest request){
        String logPre = LOG_PRE + "[verifyBindSms][${prefix}验卡]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        BindCardVerifyCommand command = new BindCardVerifyCommand();
        command.setVerificationId(request.getVerifyId());
        command.setVerificationCode(request.getSmsCode());
        ServiceResult<BindCardConfirm> serviceResult = standardApplicationService.bindCardVerify(channelId, request.getChannelOrderNo(), command);
        if (!serviceResult.isSuccess()) {
            log.error("{},错误, serviceResult={}, request={}", logPre, serviceResult, request);
            throw new CommonBizException("验卡服务异常");
        }

        BindCardConfirm bindCardConfirm = serviceResult.getData();

    }


    /**
    * 申请提现
    *
    * @param request
    * @return
    */
    @Override
    public void applyWithdraw(${prefix}ApplyLoanRequest request){
        String logPre = LOG_PRE + "[applyWithdraw][${prefix}申请提现]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        ServiceResult<MoBankCardInfoOutput> bankInfoResult = moOrderRepresentationService.queryBankCardInfoByBindCardId(request.getBindId());
        if (!bankInfoResult.isSuccess()) {
            log.error("{},错误，bankInfoResult={} bindId={}", logPre, bankInfoResult,request.getBindId());
            throw new CommonBizException("查询卡信息服务异常");
        }
        MoBankCardInfoOutput bankCardInfoOutput = bankInfoResult.getData();
        WithDrawCommand command = new WithDrawCommand();
        command.setLoanPurpose(${prefix}LoanPurposesEnum.getKoaLaPurpose(request.getLoanPurpose()));
        command.setBankCardNumber(bankCardInfoOutput.getCardNo());
        ChannelOrder order = ChannelOrder.builder()
                .channelId(channelId)
                .channelOrderNo(request.getChannelOrderNo())
                .channelLoanNo(request.getChannelLoanNo())
                .build();
        ServiceResult<WithdrawResult> serviceResult = standardApplicationService.withdraw(order, command);
        if (!serviceResult.isSuccess()) {
            log.error("{},申请提现失败，serviceResult={}， request={}", logPre, serviceResult, command);
            throw new CommonBizException("申请提现服务异常");
        }

        WithdrawResult withdrawResult = serviceResult.getData();

    }


    /**
    * 查询还款结果
    *
    * @param request
    * @return
    */
    @Override
    public void queryRepayResult(${prefix}QueryRepayRequest request){
        String logPre = LOG_PRE + "[queryRepayResult][${prefix}查询还款结果]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        ChannelOrder channelOrder = ChannelOrder.builder()
            .channelId(channelId)
            .build();
        ServiceResult<QueryNormalRepayRepresentation> serviceResult = standardApplicationService.normalRepayResultQuery(channelOrder, request.getBusinessFlowNo());
        if (!serviceResult.isSuccess()) {
            log.error("{},失败，serviceResult={}， request={}", logPre, serviceResult, request);
            throw new CommonBizException("查询还款结果服务异常");
        }
        QueryNormalRepayRepresentation repayResult = serviceResult.getData();
        Long loanId = Long.valueOf(repayResult.getLoanId());
        // 查询借据信息
        LoanMapping loanMapping = loanMappingService.findByLoanIdAndChannelId(loanId, channelId);
        if (Objects.isNull(loanMapping)) {
            log.error("{}通过loanId查询LoanMapping为空, loanId={}, channelId={}", logPre, loanId, channelId);
            throw new CommonBizException("查询借据信息异常");
        }
        String channelLoanNo = loanMapping.getChannelLoanNo();
        // 查询还款计划
        ServiceResult<OrderRepaymentRepresentation> repaymentServiceResult = standardApplicationService.repaymentPlanQueryByCycleQuota(loanId);
        if (!repaymentServiceResult.isSuccess()) {
            log.error("{},查询还款计划返回错误或无数据,loanId={}", logPre, loanId);
            throw new CommonBizException("查询还款计划异常");
        }
        List<RepaymentPlanItem> repaymentPlans = repaymentServiceResult.getData().getRepaymentPlans();

    }


    /**
    * 借款结果查询
    *
    * @param request
    * @return
    */
    @Override
    public void queryLoanResult(${prefix}QueryLoanRequest request){
        String logPre = LOG_PRE + "[queryLoanResult][${prefix}查询借款结果]";
        log.info("{} request={}",logPre,request);
        Long channelId =request.getChannelId();
        String channelLoanNo = request.getChannelLoanNo();
        LoanMapping loanMapping = loanMappingService.findByChannelLoanNoAndChannelId(channelLoanNo, channelId);
        if (Objects.isNull(loanMapping)) {
            log.error("{},查询借款订单为空，channelLoan={}", logPre, channelLoanNo);
            throw new CommonBizException("查询借据信息异常");
        }
        LoanOrderMapping orderMapping = loanOrderMappingService.findById(loanMapping.getOrderMappingId());
        if (Objects.isNull(orderMapping)) {
            log.error("{}查询授信订单失败, result为空, request={}", logPre, request);
            throw new CommonBizException("查询授信订单异常");
        }
        ServiceResult<OrderStatus> serviceResult = standardApplicationService.queryOrderStatus(orderMapping.getChannelOrderNo(), channelLoanNo, channelId, null);
        if (!serviceResult.isSuccess()) {
            log.error("{}查询订单状态失败, result={}, request={}", logPre, serviceResult, request);
            throw new CommonBizException("查询订单状态服务异常");
        }

        OrderStatus orderStatus = serviceResult.getData();


    }

    /**
    * 主动还款
    *
    * @param request
    * @return
    */
    @Override
    public void repayByPlan(${prefix}RepayByPlanRequest request){
        String logPre = LOG_PRE + "[repayByPlan][{prefix}发起主动还款]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        ServiceResult<MoBankCardInfoOutput> bankInfoResult = moOrderRepresentationService.queryBankCardInfoByBindCardId(request.getBindId());
        if (!bankInfoResult.isSuccess()) {
            log.error("{},错误，bankInfoResult={}", logPre, bankInfoResult);
            throw new CommonBizException("查询卡信息服务异常");
        }
        MoBankCardInfoOutput bankCardInfoOutput = bankInfoResult.getData();

        ChannelOrder channelOrder = ChannelOrder.builder()
            .channelId(channelId)
            .channelLoanNo(request.getChannelLoanNo())
            .build();
        String remoteIP = IpUtil.getRemoteIP(httpServletRequest);
        final NormalRepayCommand command = NormalRepayCommand.builder()
            .payBusinessFlowNo(request.getBusinessFlowNo())
            .termNo(Long.valueOf(request.getTermNo()))
            .repayAmount(new BigDecimal(request.getRepayAmount()))
            .bankCardNumber(bankCardInfoOutput.getCardNo())
            .clientIp(remoteIP)
            .build();
        ServiceResult<RepayResultRepresentation> serviceResult = standardApplicationService.normalRepayByCycleQuota(channelOrder, command);
        if (!serviceResult.isSuccess()) {
            log.error("{},失败, serviceResult={}, channelOrder={}, NormalRepayCommand={}", logPre, serviceResult, channelOrder, command);
            throw new CommonBizException("还款服务异常");
        }

        RepayResultRepresentation repayResultRepresentation = serviceResult.getData();
    }





}