package ${modelPackage};


import cn.quantgroup.cashloanflow.util.DateUtil;
import cn.quantgroup.clf.api.jinshan.util.JinShanUtil;
import cn.quantgroup.loanflow.repay.model.representation.TrialRepaymentRepresentation;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
* 借款试算出参
*
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
@Data
public class ${prefix}QueryLoanTrialResult {

    /**
    * 息费总和
    */
    private BigDecimal receivableTotalAmount;
    /**
    * 利息总和
    */
    private BigDecimal receivableInterestAmount;

    private List<${prefix}TrialInoutPlan> trialInoutPlanList;


    public static ${prefix}QueryLoanTrialResult getCoverResult(TrialRepaymentRepresentation data) {
        ${prefix}QueryLoanTrialResult result = new ${prefix}QueryLoanTrialResult();
        result.setReceivableInterestAmount(data.getTotalInterest());
        result.setReceivableTotalAmount(data.getTotalLoanAmount().add(data.getTotalInterest().add(data.getServiceFee())));
        result.setTrialInoutPlanList(getTrialInoutPlanList(data.getRepaymentPlans()));
        return result;
    }
    private static List<${prefix}TrialInoutPlan> getTrialInoutPlanList(List<TrialRepaymentRepresentation.TrialRepaymentPlan> repaymentPlans) {
        List<${prefix}TrialInoutPlan> list = new ArrayList<>();
        repaymentPlans.forEach(i ->{
            ${prefix}TrialInoutPlan plan = new ${prefix}TrialInoutPlan();
            plan.setLeaseTime(i.getPeriodNo());
            plan.setRepayDate(DateUtil.format(i.getDueTime(),DateUtil.YYYY_MM_DD));
            plan.setTermAmount(i.getRequiredRepayment());
            plan.setTermCorpus(i.getPrincipal());
            plan.setTermInterest(i.getInterest());
            plan.setExtraFee(i.getServiceFee().add(i.getOtherFee()));
            if (BigDecimal.ZERO.compareTo(plan.getExtraFee()) != 0) {
                plan.setExtraInfo("担保费");
            }
            list.add(plan);
        });
        return list;
    }

}