package cn.quantgroup.fundmanage;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;

/**
 * Created by Miraculous on 16/7/3.
 */
public class ChannelPool {

    private GenericObjectPool<Channel> pool;
    private Connection connection = null;

    private void init(ConfirmListener confirmListener) {
        try {
            PropertyHolder propertyHolder = new PropertyHolder();
            String rabbitHost = propertyHolder.getProperty("fundmanage.rabbitmq.host");
            int rabbitPort = Integer.parseInt(propertyHolder.getProperty("fundmanage.rabbitmq.port"));
            String user = propertyHolder.getProperty("fundmanage.rabbitmq.user");
            String password = propertyHolder.getProperty("fundmanage.rabbitmq.password");
            String vhost = propertyHolder.getProperty("fundmanage.rabbitmq.vhost");

            ConnectionFactory factory = new ConnectionFactory();
            factory.setUsername(user);
            factory.setPassword(password);
            factory.setVirtualHost(vhost);
            factory.setHost(rabbitHost);
            factory.setPort(rabbitPort);
            factory.setAutomaticRecoveryEnabled(true);
            factory.setConnectionTimeout(20000);
            connection = factory.newConnection();

            ChannelPoolFactory cf = new ChannelPoolFactory(connection, confirmListener);
            pool = new GenericObjectPool<>(cf);

            pool.setMaxTotal(100);
            pool.setMaxWaitMillis(30000);
            pool.setMaxIdle(8);
            pool.setMinIdle(2);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }


    private void init(ConfirmListener confirmListener,MQConfig mqConfig) {
        try {
            PropertyHolder propertyHolder = new PropertyHolder();
            String rabbitHost = propertyHolder.getProperty("fundmanage.rabbitmq.host");
            int rabbitPort = Integer.parseInt(propertyHolder.getProperty("fundmanage.rabbitmq.port"));
            String user = propertyHolder.getProperty("fundmanage.rabbitmq.user");
            String password = propertyHolder.getProperty("fundmanage.rabbitmq.password");
            String vhost = propertyHolder.getProperty("fundmanage.rabbitmq.vhost");

            if(mqConfig.getHost() != null || !"".equals(mqConfig.getHost().trim()) ){
                rabbitHost = mqConfig.getHost();
            }
            if(mqConfig.getPort() > 0){
                rabbitPort = mqConfig.getPort();
            }
            if(mqConfig.getUser() != null || !"".equals(mqConfig.getUser().trim()) ){
                user = mqConfig.getUser();
            }
            if(mqConfig.getPassword() != null || !"".equals(mqConfig.getPassword().trim()) ){
                password = mqConfig.getPassword();
            }

            if(mqConfig.getPassword() != null || !"".equals(mqConfig.getPassword().trim()) ){
                password = mqConfig.getPassword();
            }


            ConnectionFactory factory = new ConnectionFactory();
            factory.setUsername(user);
            factory.setPassword(password);
            factory.setVirtualHost(vhost);
            factory.setHost(rabbitHost);
            factory.setPort(rabbitPort);
            factory.setAutomaticRecoveryEnabled(true);
            factory.setConnectionTimeout(20000);
            connection = factory.newConnection();

            ChannelPoolFactory cf = new ChannelPoolFactory(connection, confirmListener);
            pool = new GenericObjectPool<>(cf);

            pool.setMaxTotal(100);
            pool.setMaxWaitMillis(30000);
            pool.setMaxIdle(8);
            pool.setMinIdle(2);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }



    protected ChannelPool(ConfirmListener confirmableMsgListener) {
        init(confirmableMsgListener);
    }

protected ChannelPool(ConfirmListener confirmableMsgListener,MQConfig mqConfig) {
        init(confirmableMsgListener,mqConfig);
    }



    public Channel borrowObject() throws Exception {
        return pool.borrowObject();
    }

    public void returnObject(Channel channel) throws Exception {
        pool.returnObject(channel);
    }

    public void close() {
        try {
            // Pool
            pool.close();

            //rabbitmq connection
            this.connection.close();

        } catch (Exception e) {
            // logger.error("error:", e);
        }
    }
}
