package cn.quantgroup.fundmanage;

import com.google.gson.Gson;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;

/**
 * Created by Miraculous on 16/6/30.
 */
public class MQSender {

    private ChannelPool channelPool;

    private String exchangeName;

    private static final Gson GSON = new Gson();

    private String source;

    private static final AMQP.BasicProperties PROPERTIES =  new AMQP.BasicProperties.Builder().
    contentType("text/plain").contentEncoding("utf8").
    deliveryMode(1).expiration("240000").build();

    public MQSender() {
        this(null);
    }
    public MQSender(String host,int port,String user,String password,String exchange,String vhost) {
        this(null, host, port, user, password, exchange, vhost);

    }

    public MQSender(ConfirmListener confirmListener,String host,int port,String user,String password,String exchange,String vhost) {
        PropertyHolder propertyHolder = new PropertyHolder();
        exchangeName = propertyHolder.getProperty("fundmanage.rabbitmq.exchange-name");
        MQConfig config  = new MQConfig();
        config.setHost(host);
        config.setPort(port);
        config.setUser(user);
        config.setPassword(password);
        config.setExchange(exchange);
        config.setVhost(vhost);

        channelPool = new ChannelPool(confirmListener,config);
        boolean needBreak = false;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (inetAddress.isSiteLocalAddress() && inetAddress.getHostAddress() != null && !inetAddress.getHostAddress().startsWith("127")) {
                        this.source = inetAddress.getHostAddress();
                        needBreak = true;
                        break;
                    }
                }
                if (needBreak) {
                    break;
                }
            }

        } catch (SocketException e) {
            this.source = "unknown source";
        }
        if (null == source) {
            source = "unknown source";
        }
    }


    public MQSender(ConfirmListener confirmListener) {
        PropertyHolder propertyHolder = new PropertyHolder();
        exchangeName = propertyHolder.getProperty("fundmanage.rabbitmq.exchange-name");
        channelPool = new ChannelPool(confirmListener);
        boolean needBreak = false;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (inetAddress.isSiteLocalAddress() && inetAddress.getHostAddress() != null && !inetAddress.getHostAddress().startsWith("127")) {
                        this.source = inetAddress.getHostAddress();
                        needBreak = true;
                        break;
                    }
                }
                if (needBreak) {
                    break;
                }
            }

        } catch (SocketException e) {
            this.source = "unknown source";
        }
        if (null == source) {
            source = "unknown source";
        }
    }

    public void sendAndForget(String content) throws Exception {

        Channel channel = null;
        try {
            channel = channelPool.borrowObject();
            channel.basicPublish(exchangeName, "qunar_baitiaodebt", false, false,
                    PROPERTIES, content.getBytes("utf8"));
        } finally {
            if (channel != null) {
                channelPool.returnObject(channel);
            }
        }
    }

    public void sendConfirmableMessage(ConfirmableMsg message) throws Exception {
        if (message == null || !message.checkIntegrity()) {
            return;
        }
        message.setSource(source);
        String messageStr = GSON.toJson(message);
        Channel channel = null;
        try {
            channel = channelPool.borrowObject();
            channel.basicPublish(exchangeName, "confirmable", false, false,
                    PROPERTIES, messageStr.getBytes("utf8"));
        } finally {
            if (channel != null) {
                channelPool.returnObject(channel);
            }
        }
    }

    public void confirmSmsResult(String merchantId, String uniqueId) throws Exception {
        String message = "{\"merchantId\":\"" + merchantId +
                "\",\"uniqueId\":\"" + uniqueId + "\"}";
        Channel channel = null;
        try {
            channel = channelPool.borrowObject();
            channel.basicPublish(exchangeName, "confirm", false, false,
                    PROPERTIES, message.getBytes("utf8"));
        } finally {
            if (channel != null) {
                channelPool.returnObject(channel);
            }
        }
    }

}
