package cn.quantgroup.fundmanage.config.message;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.UUID;

/**
 * Created by evan on 16/9/5.
 */
@Component
public class RabbitMqSend implements RabbitTemplate.ConfirmCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMqSend.class);

    @Autowired
    @Qualifier("rabbitTemplate")
    private RabbitTemplate rabbitTemplate;

    private static final ObjectMapper MAPPER = new ObjectMapper();

    /**
     * 构造方法注入
     */
    @Autowired
    public RabbitMqSend(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
        rabbitTemplate.setConfirmCallback(this);
    }

    @Override
    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        LOGGER.info(" 回调id:" + correlationData);
        if (ack) {
            LOGGER.info("消息成功消费");
        } else {
            LOGGER.info("消息消费失败:" + cause);
        }
    }

    public void sendMsg(String content) {
        CorrelationData correlationId = new CorrelationData(UUID.randomUUID().toString());
        String obj = null;
        try {
            obj = MAPPER.writeValueAsString("");
        } catch (JsonProcessingException e) {
            throw new RuntimeException("序列化json失败");
        }
        rabbitTemplate.convertAndSend(obj, correlationId);
    }
}
