/*
 * Decompiled with CFR 0.152.
 */
package cn.quantgroup.fundmanage;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class ChannelPoolFactory
extends BasePooledObjectFactory<Channel> {
    private Connection connection;
    private ConfirmListener confirmListener;

    public ChannelPoolFactory(Connection c) {
        this(c, null);
    }

    public ChannelPoolFactory(Connection c, ConfirmListener confirmListener) {
        this.connection = c;
        this.confirmListener = confirmListener;
    }

    public Channel create() throws Exception {
        Channel channel = this.connection.createChannel();
        if (this.confirmListener != null) {
            channel.addConfirmListener(this.confirmListener);
        }
        return channel;
    }

    public PooledObject<Channel> wrap(Channel channel) {
        return new DefaultPooledObject((Object)channel);
    }

    public void passivateObject(PooledObject<Channel> p) throws Exception {
        super.passivateObject(p);
    }

    public boolean validateObject(PooledObject<Channel> p) {
        Channel channel = (Channel)p.getObject();
        return channel.isOpen();
    }

    public void destroyObject(PooledObject<Channel> p) throws Exception {
        ((Channel)p.getObject()).close();
    }
}

