/*
 * Decompiled with CFR 0.152.
 */
package cn.quantgroup.fundmanage;

import cn.quantgroup.fundmanage.ChannelPool;
import cn.quantgroup.fundmanage.ConfirmableMsg;
import cn.quantgroup.fundmanage.MQConfig;
import cn.quantgroup.fundmanage.PropertyHolder;
import com.google.gson.Gson;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;

public class MQSender {
    private ChannelPool channelPool;
    private String exchangeName;
    private static final Gson GSON = new Gson();
    private String source;
    private static final AMQP.BasicProperties PROPERTIES = new AMQP.BasicProperties.Builder().contentType("text/plain").contentEncoding("utf8").deliveryMode(Integer.valueOf(1)).expiration("240000").build();

    public MQSender() {
        this(null);
    }

    public MQSender(String host, int port, String user, String password, String exchange, String vhost) {
        this(null, host, port, user, password, exchange, vhost);
    }

    public MQSender(ConfirmListener confirmListener, String host, int port, String user, String password, String exchange, String vhost) {
        PropertyHolder propertyHolder = new PropertyHolder();
        this.exchangeName = propertyHolder.getProperty("fundmanage.rabbitmq.exchange-name");
        MQConfig config = new MQConfig();
        config.setHost(host);
        config.setPort(port);
        config.setUser(user);
        config.setPassword(password);
        config.setExchange(exchange);
        config.setVhost(vhost);
        this.channelPool = new ChannelPool(confirmListener, config);
        boolean needBreak = false;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (!inetAddress.isSiteLocalAddress() || inetAddress.getHostAddress() == null || inetAddress.getHostAddress().startsWith("127")) continue;
                    this.source = inetAddress.getHostAddress();
                    needBreak = true;
                    break;
                }
                if (!needBreak) continue;
                break;
            }
        }
        catch (SocketException e) {
            this.source = "unknown source";
        }
        if (null == this.source) {
            this.source = "unknown source";
        }
    }

    public MQSender(ConfirmListener confirmListener) {
        PropertyHolder propertyHolder = new PropertyHolder();
        this.exchangeName = propertyHolder.getProperty("fundmanage.rabbitmq.exchange-name");
        this.channelPool = new ChannelPool(confirmListener);
        boolean needBreak = false;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (!inetAddress.isSiteLocalAddress() || inetAddress.getHostAddress() == null || inetAddress.getHostAddress().startsWith("127")) continue;
                    this.source = inetAddress.getHostAddress();
                    needBreak = true;
                    break;
                }
                if (!needBreak) continue;
                break;
            }
        }
        catch (SocketException e) {
            this.source = "unknown source";
        }
        if (null == this.source) {
            this.source = "unknown source";
        }
    }

    public void sendAndForget(String content) throws Exception {
        Channel channel = null;
        try {
            channel = this.channelPool.borrowObject();
            channel.basicPublish(this.exchangeName, "qunar_baitiaodebt", false, false, PROPERTIES, content.getBytes("utf8"));
        }
        finally {
            if (channel != null) {
                this.channelPool.returnObject(channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendConfirmableMessage(ConfirmableMsg message) throws Exception {
        if (message == null || !message.checkIntegrity()) {
            return;
        }
        message.setSource(this.source);
        String messageStr = GSON.toJson((Object)message);
        Channel channel = null;
        try {
            channel = this.channelPool.borrowObject();
            channel.basicPublish(this.exchangeName, "confirmable", false, false, PROPERTIES, messageStr.getBytes("utf8"));
        }
        finally {
            if (channel != null) {
                this.channelPool.returnObject(channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmSmsResult(String merchantId, String uniqueId) throws Exception {
        String message = "{\"merchantId\":\"" + merchantId + "\",\"uniqueId\":\"" + uniqueId + "\"}";
        Channel channel = null;
        try {
            channel = this.channelPool.borrowObject();
            channel.basicPublish(this.exchangeName, "confirm", false, false, PROPERTIES, message.getBytes("utf8"));
        }
        finally {
            if (channel != null) {
                this.channelPool.returnObject(channel);
            }
        }
    }
}

