package cn.quantgroup;

import cn.quantgroup.fundmanage.Constants;
import org.apache.commons.cli.*;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.orm.jpa.EntityScan;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.*;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.transaction.annotation.EnableTransactionManagement;


/**
 * Created by Rocky on 2016/8/31.
 */
@ComponentScan(basePackages = {"cn.quantgroup.fundmanage"})
@EntityScan(basePackages = {"cn.quantgroup.fundmanage.entity"})
@EnableAutoConfiguration
@EnableJpaRepositories(basePackages = {"cn.quantgroup.fundmanage.repository"})
@PropertySource({"classpath:application.properties",
        "classpath:fundmanage.properties"})
@EnableTransactionManagement
@EnableScheduling
@EnableAsync
@EnableAspectJAutoProxy
@Configuration
@SpringBootApplication
public class Bootstrap {
    public static void parseOptions(String[] args) throws ParseException {
        Options opt = new Options();
        Option worker = new Option("w", "worker", true, "total workers");
        worker.setRequired(true);
        Option currentWorker = new Option("cw", "currentWorker", true, "current worker");
        currentWorker.setRequired(true);
        opt.addOption("h", "help", false, "--worker=totalWorkers --currentWorker=currentWorker")
                .addOption(worker)
                .addOption(currentWorker);
        CommandLineParser parser = new DefaultParser();
        CommandLine commandLine = parser.parse(opt, args, true);
        if (!commandLine.hasOption("w") || !commandLine.hasOption("cw")) {
            throw new ParseException("must with --worker and --currentWorker args specified");
        }
        String value = commandLine.getOptionValue("worker");
        if (StringUtils.isNumeric(value) && StringUtils.isNotEmpty(value)) {
            Constants.Concurrent.WORKERS = Long.valueOf(value);
        } else {
            throw new ParseException("--worker must be a number");
        }
        value = commandLine.getOptionValue("currentWorker");
        if (StringUtils.isNumeric(value) && StringUtils.isNotEmpty(value)) {
            Constants.Concurrent.CURRENT_WORKER = Long.valueOf(value);
        } else {
            throw new ParseException("--currentWoker must be a number");
        }
    }

    public static void main(String[] args) throws ParseException {
        parseOptions(args);
        SpringApplication.run(Bootstrap.class, args);
    }
}
