package cn.quantgroup.fundmanage.config.message;

import cn.quantgroup.fundmanage.service.message.IMessageHandler;
import cn.quantgroup.fundmanage.service.message.impl.GenContractSuccessHandler;
import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.adapter.MessageListenerAdapter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by Rocky on 2016/9/5.
 */
@Configuration
public class RabbitMqConfig {
    @Value("${baitiaodebt.rabbitmq.queue.quanarorder}")
    private String sucQueueName;
    @Value("${baitiaodebt.rabbitmq.exchange.quanarorder}")
    private String fundmanageExchange;
    @Value("${rabbitmq.connection.host}")
    private String host;
    @Value("${rabbitmq.connection.port}")
    private Integer port;
    @Value("${rabbitmq.connection.user}")
    private String user;
    @Value("${rabbitmq.connection.password}")
    private String password;
    @Value("${rabbitmq.connection.virtual-host}")
    private String virtualHost;

    @Bean(name = "blackHoleConnection")
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
        connectionFactory.setChannelCacheSize(1024);
        connectionFactory.setCacheMode(CachingConnectionFactory.CacheMode.CONNECTION);
        connectionFactory.setChannelCacheSize(180 * 1000);
        connectionFactory.setConnectionCacheSize(1024);
        connectionFactory.setUsername(user);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost(virtualHost);
        connectionFactory.setPublisherReturns(false);
        connectionFactory.setPublisherConfirms(false);
        return connectionFactory;
    }


    @Bean(name = "blackHoleAmqpAdmin")
    public AmqpAdmin amqpAdmin(@Qualifier("blackHoleConnection")ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @Bean(name = "fundmanageExchange")
    public DirectExchange directExchange() {
        return new DirectExchange(fundmanageExchange);
    }

    @Bean(name = "contractSucQueue")
    public Queue contractSucQueue() {
        return new Queue(sucQueueName);
    }

    @Bean(name = "contractSucBinding")
    public Binding bindingSuc(@Qualifier("blackHoleAmqpAdmin")AmqpAdmin amqpAdmin, @Qualifier("contractSucQueue")Queue contractQueue, @Qualifier("fundmanageExchange")DirectExchange directExchange) {
        Binding binding = BindingBuilder.bind(contractQueue).to(directExchange).with(contractQueue.getName());
        amqpAdmin.declareBinding(binding);
        return binding;
    }

    @Bean(name = "rabbitTemplate")
    public RabbitTemplate contractTemplate(@Qualifier("blackHoleConnection")ConnectionFactory connectionFactory) {
        RabbitTemplate template = new RabbitTemplate(connectionFactory);
        template.setExchange(fundmanageExchange);
        return template;
    }

    @Bean(name = "blackHoleListenerContainer")
    public SimpleMessageListenerContainer container(@Qualifier("blackHoleConnection")ConnectionFactory connectionFactory,
                                                    @Qualifier("contractSucQueue")Queue contractQueue,
                                                    MessageListenerAdapter listenerAdapter) {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.setQueues(contractQueue);
        container.setAcknowledgeMode(AcknowledgeMode.AUTO);
        container.setMessageListener(listenerAdapter);
        container.start();
        return container;
    }

    @Bean(name = "simpleHandler")
    IMessageHandler receiver() {
        return new GenContractSuccessHandler();
    }

    @Bean
    MessageListenerAdapter listenerAdapter(@Qualifier("simpleHandler")IMessageHandler messageHandler) {
        return new MessageListenerAdapter(messageHandler, "handle");
    }

}
