package cn.quantgroup.fundmanage.config.message;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by Rocky on 2016/9/5.
 */
@Configuration
public class RabbitMq4FinancialConfig {

    @Value("${rabbitmq.financial.exchange}")
    private String financialExchange;
    @Value("${rabbitmq.connection.host}")
    private String host;
    @Value("${rabbitmq.connection.port}")
    private Integer port;
    @Value("${rabbitmq.connection.user}")
    private String user;
    @Value("${rabbitmq.connection.password}")
    private String password;
    @Value("${rabbitmq.connection.virtual-host.financial}")
    private String virtualHost;
    @Value("${rabbitmq.connection.queue.baitiaoOrder}")
    private String baitiaoOrderQueue;

    private static volatile CachingConnectionFactory cachingConnectionFactory2;

//    @Bean(name = "financialConnection")
    private CachingConnectionFactory cachingConnectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
        connectionFactory.setChannelCacheSize(1024);
        connectionFactory.setCacheMode(CachingConnectionFactory.CacheMode.CONNECTION);
        connectionFactory.setChannelCacheSize(180 * 1000);
        connectionFactory.setConnectionCacheSize(1024);
        connectionFactory.setUsername(user);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost(virtualHost);
        connectionFactory.setPublisherReturns(false);
        connectionFactory.setPublisherConfirms(false);
        return connectionFactory;
    }

    @Bean(name = "financialRabbitAdmin")
    public RabbitAdmin rabbitAdmin() {
//    public RabbitAdmin rabbitAdmin(@Qualifier("financialConnection")CachingConnectionFactory cachingConnectionFactory) {
       if (cachingConnectionFactory2 == null) {
            cachingConnectionFactory2 = cachingConnectionFactory();
        }
        return new RabbitAdmin(cachingConnectionFactory2);
    }

    @Bean(name = "financialExchange")
    public DirectExchange directExchange() {
        return new DirectExchange(financialExchange, true, false);
    }

    @Bean(name = "baitiaoOrder")
    public Queue baitiaoOrderQueue(){
        return  new Queue(baitiaoOrderQueue);
    }

    @Bean(name = "baitiaoOrderBinding")
    public Binding baitiaoOrderBinding(@Qualifier("financialRabbitAdmin")RabbitAdmin rabbitAdmin, @Qualifier("baitiaoOrder")Queue baitiaoOrder, @Qualifier("financialExchange")DirectExchange directExchange) {
        Binding binding = BindingBuilder.bind(baitiaoOrder).to(directExchange).with(baitiaoOrder.getName());
        rabbitAdmin.declareBinding(binding);
        return binding;
    }




    @Bean(name = "financialRabbitTemplate")
    public RabbitTemplate financialRabbitTemplate() {
//    public RabbitTemplate contractTemplate(@Qualifier("financialConnection")ConnectionFactory connectionFactory) {
        if (cachingConnectionFactory2 == null) {
            cachingConnectionFactory2 = cachingConnectionFactory();
        }
        RabbitTemplate template = new RabbitTemplate(cachingConnectionFactory2);
        template.setExchange(financialExchange);
        return template;
    }

}
