package cn.quantgroup.fundmanage.config.rabbitmq;


import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by Rocky on 2016/9/5.
 */
@Configuration
public class RabbitMqConfig {
    @Value("${baitiaodebt.rabbitmq.queue.quanarorder}")
    private String qunarBTQueue;
    @Value("${baitiaodebt.rabbitmq.exchange.quanarorder}")
    private String baitiaodebtExchange;
    @Value("${rabbitmq.connection.host}")
    private String host;
    @Value("${rabbitmq.connection.port}")
    private Integer port;
    @Value("${rabbitmq.connection.user}")
    private String user;
    @Value("${rabbitmq.connection.password}")
    private String password;
    @Value("${rabbitmq.connection.virtual-host}")
    private String virtualHost;

    @Bean
    public CachingConnectionFactory cachingConnectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
        connectionFactory.setChannelCacheSize(1024);
        connectionFactory.setCacheMode(CachingConnectionFactory.CacheMode.CONNECTION);
        connectionFactory.setChannelCacheSize(180 * 1000);
        connectionFactory.setConnectionCacheSize(1024);
        connectionFactory.setUsername(user);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost(virtualHost);
        connectionFactory.setPublisherReturns(false);
        connectionFactory.setPublisherConfirms(false);
        return connectionFactory;
    }

    @Bean
    public RabbitAdmin rabbitAdmin(CachingConnectionFactory cachingConnectionFactory) {
        return new RabbitAdmin(cachingConnectionFactory);
    }

    @Bean
    public DirectExchange directExchange() {
        return new DirectExchange(baitiaodebtExchange, true, false);
    }

    @Bean(name = "rabbitTemplate")
    public RabbitTemplate qunarBTRabbitTemplate(CachingConnectionFactory cachingConnectionFactory) {
        RabbitTemplate template = new RabbitTemplate(cachingConnectionFactory);
        template.setExchange(baitiaodebtExchange);
        return template;
    }

    @Bean(name = "qunarBTQueue")
    public Queue qunarBTQueue() {  //还款的queue
        return new Queue(qunarBTQueue);
    }


    @Bean(name = "qunarBTQueueBinding")
    public Binding bindingQunarBT(RabbitAdmin rabbitAdmin, @Qualifier("qunarBTQueue")Queue qunarBTQueue, DirectExchange directExchange) {
        Binding binding = BindingBuilder.bind(qunarBTQueue).to(directExchange).with(qunarBTQueue.getName());
        rabbitAdmin.declareBinding(binding);
        return binding;
    }

}
