package cn.quantgroup.fundmanage.service.rabbitmq.impl;

import cn.quantgroup.fundmanage.model.BaiTiaoType;
import cn.quantgroup.fundmanage.model.JsonResult;
import cn.quantgroup.fundmanage.service.rabbitmq.IRabbitMQ;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
 * Created by Rocky on 2016/9/6.
 */
@Service
public class RabbitMQImpl implements IRabbitMQ{
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMQImpl.class);

    @Autowired
    @Qualifier("rabbitTemplate")
    private RabbitTemplate rabbitTemplate;

    @Autowired
    @Qualifier("qunarBTQueue")
    private Queue qunarBTQueue;

    private String queueName ;

    public JsonResult send(String content,BaiTiaoType type){
        queueName= qunarBTQueue.getName();
        if(type == BaiTiaoType.QUNAR_BNAITIAO){
            queueName= qunarBTQueue.getName();
        }

        // other baitiao channel-- begin

        // other baitiao channel-- end

        try{
            rabbitTemplate.convertAndSend(queueName, content);
        }catch (Exception e){
            LOGGER.error(e.getMessage(),e);
            return JsonResult.buildErrorStateResult(e.getMessage(),e);
        }


        return JsonResult.buildSuccessResult("success",null);
    }
}
