package cn.quantgroup;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.orm.jpa.EntityScan;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * Created by Rocky on 2016/8/31.
 */
@ComponentScan(basePackages = "cn.quantgroup")
@EntityScan(basePackages = {"cn.quantgroup.fundmanage.entity"})
@EnableAutoConfiguration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages = {"cn.quantgroup.fundmanage.repository"})
@SpringBootApplication
@PropertySource({"classpath:application.properties", "classpath:fundmanage.properties"})
@EnableAspectJAutoProxy
@EnableAsync
@Configuration
public class Bootstrap {
/*    public static void parseOptions(String[] args) throws ParseException {
        Options opt = new Options();
        Option worker = new Option("w", "worker", true, "total workers");
        worker.setRequired(true);
        Option currentWorker = new Option("cw", "currentWorker", true, "current worker");
        currentWorker.setRequired(true);
        opt.addOption("h", "help", false, "--worker=totalWorkers --currentWorker=currentWorker")
                .addOption(worker)
                .addOption(currentWorker);
        CommandLineParser parser = new DefaultParser();
        CommandLine commandLine = parser.parse(opt, args, true);
        if (!commandLine.hasOption("w") || !commandLine.hasOption("cw")) {
            System.out.println("must with --worker and --currentWorker args specified");
            System.exit(-1);
        }
        String value = commandLine.getOptionValue("worker");
        if (StringUtils.isNumeric(value) && StringUtils.isNotEmpty(value)) {
            Constants.Concurrent.WORKERS = Long.valueOf(value);
        } else {
            System.out.println("--worker must be a number");
            System.exit(-1);
        }
        value = commandLine.getOptionValue("currentWorker");
        if (StringUtils.isNumeric(value) && StringUtils.isNotEmpty(value)) {
            Constants.Concurrent.CURRENT_WORKER = Long.valueOf(value);
        } else {
            System.out.println("--currentWoker must be a number");
            System.exit(-1);
        }
    }*/

    public static void main(String[] args) {
        // parseOptions(args);
        SpringApplication.run(Bootstrap.class, args);
    }
}
