package cn.quantgroup.fs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * Created by Miraculous on 16/6/30.
 */
class PropertyHolder {

    private Properties properties = new Properties();
    public PropertyHolder() {
        InputStream stream = null;
        try {
            stream = PropertyHolder.class.getResourceAsStream("/config.properties");
            properties.load(stream);
        } catch (IOException e) {
            System.out.println("fs can not init, reason: " + e.getMessage());
            System.exit(-1);
        } finally {
            if (null != stream) {
                try {
                    stream.close();
                } catch (IOException e) {
                    // ignore
                }
            }
        }

    }

    public String getProperty(String propertyName) {
        if (!properties.containsKey(propertyName)) {
            System.out.println("can not find property with name in fs sdk: " + propertyName);
            System.exit(-1);
        }
        return properties.getProperty(propertyName);
    }

}
