package cn.quantgroup.fs;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

/**
 * Created by Miraculous on 16/7/3.
 */
public class ChannelPoolFactory extends BasePooledObjectFactory<Channel> {

    private Connection connection;
    private ConfirmListener confirmListener;

    public ChannelPoolFactory(Connection c) {
        this(c, null);
    }

    public ChannelPoolFactory(Connection c, ConfirmListener confirmListener) {
        this.connection = c;
        this.confirmListener = confirmListener;
    }

    @Override
    public Channel create() throws Exception {
        Channel channel = connection.createChannel();
        if (this.confirmListener != null) {
            channel.addConfirmListener(confirmListener);
        }
        return channel;
    }

    @Override
    public PooledObject<Channel> wrap(Channel channel) {
        return new DefaultPooledObject<>(channel);
    }

    @Override
    public void passivateObject(PooledObject<Channel> p) throws Exception {
        super.passivateObject(p);
    }

    @Override
    public boolean validateObject(PooledObject<Channel> p) {
        Channel channel = p.getObject();
        return channel.isOpen();
    }

    @Override
    public void destroyObject(PooledObject<Channel> p) throws Exception {
        p.getObject().close();
    }
}
