package cn.quantgroup.fs;

import com.google.gson.Gson;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;

/**
 * Created by ocean on 2016/7/25.
 */
public class LoanInfoSender {

    private ChannelPool channelPool;

    private String exchangeName;

    private static final Gson GSON = new Gson();


    private static final AMQP.BasicProperties PROPERTIES =  new AMQP.BasicProperties.Builder().
            contentType("text/plain").contentEncoding("utf8").
            deliveryMode(1).expiration("240000").build();

    public LoanInfoSender() {
        this(null);
    }

    public LoanInfoSender(ConfirmListener confirmListener) {
        PropertyHolder propertyHolder = new PropertyHolder();
        exchangeName = propertyHolder.getProperty("fs.rabbitmq.exchange-name");
        channelPool = new ChannelPool(confirmListener);
    }

    /**
     * 发送推送资金方放款相关信息到MQ
     * @param message
     * @throws Exception
     */
    public void sendLoanInfo(LoanInfo message) throws Exception {
        if (message == null ) {
            return;
        }
        String messageStr = GSON.toJson(message);
        Channel channel = null;
        try {
            channel = channelPool.borrowObject();
            channel.basicPublish(exchangeName, "loan_info", false, false,
                    PROPERTIES, messageStr.getBytes("utf8"));
        } finally {
            if (channel != null) {
                channelPool.returnObject(channel);
            }
        }
    }

}
