package cn.quantgroup.fs;

import com.google.gson.Gson;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;

/**
 * Created by ocean on 2016/7/25.
 */
public class LoanInfoSender {

    private ChannelPool channelPool;

    private String exchangeName;

    private static final Gson GSON = new Gson();

    private String source;

    private static final AMQP.BasicProperties PROPERTIES =  new AMQP.BasicProperties.Builder().
            contentType("text/plain").contentEncoding("utf8").
            deliveryMode(1).expiration("240000").build();

    public LoanInfoSender() {
        this(null);
    }

    public LoanInfoSender(ConfirmListener confirmListener) {
        PropertyHolder propertyHolder = new PropertyHolder();
        exchangeName = propertyHolder.getProperty("fs.rabbitmq.exchange-name");
        channelPool = new ChannelPool(confirmListener);
        boolean needBreak = false;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (inetAddress.isSiteLocalAddress() && inetAddress.getHostAddress() != null && !inetAddress.getHostAddress().startsWith("127")) {
                        this.source = inetAddress.getHostAddress();
                        needBreak = true;
                        break;
                    }
                }
                if (needBreak) {
                    break;
                }
            }

        } catch (SocketException e) {
            this.source = "unknown source";
        }
        if (null == source) {
            source = "unknown source";
        }
    }

    /**
     * 发送放款信息到MQ
     * @param message
     * @throws Exception
     */
    public void sendLoanInfo(LoanInfo message) throws Exception {
        if (message == null ) {
            return;
        }
        message.setSource(source);
        String messageStr = GSON.toJson(message);
        Channel channel = null;
        try {
            channel = channelPool.borrowObject();
            channel.basicPublish(exchangeName, "loan_info", false, false,
                    PROPERTIES, messageStr.getBytes("utf8"));
        } finally {
            if (channel != null) {
                channelPool.returnObject(channel);
            }
        }
    }

}
