# -*- coding: utf-8 -*-

import os
import sys
import datetime
import numpy as np
import pandas as pd

sys.path.append('../../../finance_out_table')
from db_con.db_connect import sql_engine

#path = '/home/quant_group/vpants/finance/table/'
path = '/Users/chenxiaozhe/Downloads/test/201901'
conn_w = sql_engine('audit_w', 'test_mzh').get_engine()
conn = sql_engine('audit', 'test_mzh').get_engine()
update_rate_sql_list = [
    # 520 惠金所2
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.03, qishou_service_fee_rate = 0.0 where funding_code = 520 and contract_term in (2,3)  and loan_paid_at >= {};""",
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.03, qishou_service_fee_rate = 0.0048 where funding_code = 520 and contract_term = 6 and loan_paid_at >= {};""",
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.03, qishou_service_fee_rate = 0.0037 where funding_code = 520 and contract_term = 9 and loan_paid_at >= {};""",
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.03, qishou_service_fee_rate = 0.0032 where funding_code = 520 and contract_term = 12 and loan_paid_at >= {};""",
    # 560 众网小贷2
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.03, qishou_service_fee_rate =0.180000  where funding_code = 560 and loan_paid_at >= {};""",
    # 580 惠金所4
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.03, qishou_service_fee_rate = 0.0 where funding_code = 580 and contract_term in (2,3) and loan_paid_at >= {};""",
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.03, qishou_service_fee_rate = 0.0048 where funding_code = 580 and contract_term = 6  and loan_paid_at >= {} ;""",
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.03, qishou_service_fee_rate = 0.0037 where funding_code = 580 and contract_term = 9 and loan_paid_at >= {} ;""",
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.03, qishou_service_fee_rate = 0.0032 where funding_code = 580 and contract_term = 12 and loan_paid_at >= {} ;""",
    # 210
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.0, qishou_service_fee_rate = 0.005 where funding_code = 210 and loan_paid_at >= {};""",
    # 410 490
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.0, qishou_service_fee_rate = 0.0 where funding_code in (410, 490) and loan_paid_at >= {};""",
    # 540 惠金所3
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.03, qishou_service_fee_rate = 0.0048 where funding_code = 540 and contract_term = 6 and loan_paid_at >= {};""",
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.03, qishou_service_fee_rate = 0.0037 where funding_code = 540 and contract_term = 9 and loan_paid_at >= {};""",
    """update test_mzh.loan_manifest_new set dunshou_service_fee_rate = 0.03, qishou_service_fee_rate = 0.0032 where funding_code = 540 and contract_term = 12 and loan_paid_at >= {};"""

]
update_data_sql = """
update test_mzh.loan_manifest_new set dunshou_service_fee = dunshou_service_fee_rate * contract_loan_amount, qishou_service_fee = qishou_service_fee_rate * contract_loan_amount where loan_paid_at >= {};
"""
insert_data_sql = """
insert into test_mzh.loan_manifest_new (
  id,
  product_code,
  loan_id,
  ref_id,
  funding_code,
  contract_loan_amount,
  real_loan_amount,
  contract_term,
  monthly_interest_rate,
  bearing_way,
  per_term_service_fee,
  qg_one_time_service_fee,
  funding_one_time_service_fee,
  monthly_required_repayment_amount,
  is_assignment_of_debt,
  is_active,
  created_at,
  updated_at,
  loan_paid_at,
  batch_no,
  loan_account_id,
  source_corp,
  user_biz_id,
  remark,
  batch_no_id,
  batch_no_type,
  _lock,
  contract_no,
  contract_created_at,
  class,
  dunshou_service_fee_rate,
  dunshou_service_fee,
  qishou_service_fee_rate,
  qishou_service_fee
) 
select 
  id,
  product_code,
  loan_id,
  ref_id,
  funding_code,
  contract_loan_amount,
  real_loan_amount,
  contract_term,
  monthly_interest_rate,
  bearing_way,
  per_term_service_fee,
  qg_one_time_service_fee,
  funding_one_time_service_fee,
  monthly_required_repayment_amount,
  is_assignment_of_debt,
  is_active,
  created_at,
  updated_at,
  loan_paid_at,
  batch_no,
  loan_account_id,
  source_corp,
  user_biz_id,
  remark,
  batch_no_id,
  batch_no_type,
  _lock,
  contract_no,
  contract_created_at,
  class,
  0.0 dunshou_service_fee_rate,
  0.0 dunshou_service_fee,
  0.0 qishou_service_fee_rate,
  0.0 qishou_service_fee 
from
  audit.loan_manifest 
where loan_paid_at >= {} and loan_paid_at < {};
"""

sql_details = """
SELECT 
  f.name 资金方,
  loan.loan_id,
  date(loan.loan_paid_at) 放款日期,
  loan.contract_loan_amount 放款金额,
  loan.contract_term 总期数,
  date(plan.deadline) 每期应还日,
  plan.principle 每期应还本金,
  plan.interest 每期应还利息,
  plan.service_fee,
  loan.dunshou_service_fee_rate QG向资金方收取的趸收费率,
  loan.qishou_service_fee_rate QG向资金方收取的期收费率,
  plan.term_no 'QG服务费金额2-期收的所属期数',
  loan.dunshou_service_fee 'QG服务费金额1-趸收',
  loan.qishou_service_fee,
  round(loan.qishou_service_fee / loan.contract_term, 2) 'QG服务费金额2-期收',
  0 服务费合计,
  loan.class 风险等级,
  loan.funding_code, 
  plan.id plan_id,
  year(loan.loan_paid_at) 放款年,
  month(loan.loan_paid_at) 放款月,
  year(plan.deadline) 应还年,
  month(plan.deadline) 应还月,
  plan.required_repayment 应还总额
FROM
  test_mzh.loan_manifest_new loan 
  JOIN new_transaction.user_repayment_plan plan 
    ON plan.ref_id = loan.ref_id  
  JOIN basic.funding_corp f 
    ON f.funding_code = loan.funding_code
;
"""
sql_real_fee = """
SELECT 
  plan.id plan_id,
  ref.ref_amount,
  ref.principle - ref.mitigate_principle real_principle,
  ref.interest - ref.mitigate_interest real_interest,
  ref.service_fee - ref.mitigate_service_fee real_service_fee,
  date(ref.bill_time) bill_time,
  year(ref.bill_time) bill_year,
  month(ref.bill_time) bill_month 
FROM
  test_mzh.loan_manifest_new loan 
  JOIN new_transaction.user_repayment_plan plan 
    ON plan.ref_id = loan.ref_id 
    AND loan.funding_code in (410, 490, 560) 
    and plan.deadline >= '2017-12-01'
  JOIN new_transaction.xjd_repay_plan_repay_record_ref ref 
    ON ref.plan_id = plan.id 
    and ref.bill_time >= '2017-12-01' 
    and ref.bill_time < {}
;
"""

#可能要加 user_repayment_plan.repay_status=3
sql_real_term = """
select 
  plan.id plan_id,
  date(ref.bill_time) bill_time,
  year(ref.bill_time) bill_year,
  month(ref.bill_time) bill_month 
from
  new_transaction.user_repayment_plan plan 
  join new_transaction.xjd_repay_plan_repay_record_ref ref 
    on ref.plan_id = plan.id 
    and plan.repay_status=3
    and plan.fund_code = 210 
    and plan.deadline >= '2017-12-01' 
    and ref.bill_time >= '2017-12-01'
    and ref.bill_time < {}
order by 2 ;
"""

"""
    410, 490: 渤海
    210: 广源
    520, 540, 1000：惠金所
    560：众网小贷2
"""


class new_income_confirm():
    def __init__(self, is_mock):
        self.is_mock = is_mock
        today = datetime.date.today()
        self.end = datetime.date(today.year, today.month, 1)
        last_day = self.end + datetime.timedelta(days=-1)
        self.start = datetime.date(last_day.year, last_day.month, 1)
        self.dir_path = path + self.start.strftime('%Y%m')
        if not os.path.exists(self.dir_path):
            os.makedirs(self.dir_path)

    def income_confirm_details(self):
        if not self.is_mock:
            # 准备数据
            conn_w.execute(insert_data_sql.format(self.start.strftime("'%Y-%m-%d'"), self.end.strftime("'%Y-%m-%d'")))

            # 更新费率
            for sql in update_rate_sql_list:
                conn_w.execute(sql.format(self.start.strftime("'%Y-%m-%d'")))

            # 更新数据
            conn_w.execute(update_data_sql.format(self.start.strftime("'%Y-%m-%d'")))

        # 出表
        df = pd.read_sql(sql=sql_details, con=conn)
        df = df.loc[df.funding_code != 480]
        df_410 = pd.read_sql(sql=sql_real_fee.format(self.end.strftime("'%Y-%m-%d'")), con=conn)
        df_210 = pd.read_sql(sql=sql_real_term.format(self.end.strftime("'%Y-%m-%d'")), con=conn)
        df_210.drop_duplicates(['plan_id'], keep='last', inplace=True)
        # 处理明细
        funding_codes = list(df.funding_code.unique())
        dunshou_ret = []
        qishou_ret = []
        for fc in funding_codes:
            df_tmp = df.loc[df.funding_code == fc].copy()
            # 趸收
            df_tmp_dunshou = df_tmp.loc[df_tmp['QG服务费金额2-期收的所属期数'] == 1].copy()
            df_tmp_dunshou['QG服务费金额1-趸收'] = np.round(df_tmp_dunshou['QG服务费金额1-趸收'], 2)
            df_tmp_dunshou[['QG服务费金额2-期收的所属期数', '应还年', '应还月']] = 0
            df_tmp_dunshou[['每期应还日', '应还年', '应还月']] = None
            df_tmp_dunshou[['每期应还本金', '每期应还利息', 'service_fee', 'QG向资金方收取的期收费率', 'QG服务费金额2-期收', '应还总额']] = 0.0
            dunshou_ret.append(df_tmp_dunshou)

            # 期收
            df_tmp[['放款金额', 'QG向资金方收取的趸收费率', 'QG服务费金额1-趸收']] = 0.0
            df_tmp['qishou_service_fee'] = np.round(df_tmp['qishou_service_fee'], 2)
            if fc in (410, 490):
                df_tmp = pd.merge(df_tmp, df_410, on='plan_id')
                df_tmp['每期应还日'] = df_tmp['bill_time']
                df_tmp['每期应还本金'] = df_tmp['real_principle']
                df_tmp['每期应还利息'] = df_tmp['real_interest']
                df_tmp['QG服务费金额2-期收'] = df_tmp['real_service_fee']
                df_tmp['应还年'] = df_tmp['bill_year']
                df_tmp['应还月'] = df_tmp['bill_month']
                df_tmp['应还总额'] = df_tmp['ref_amount']
                title_list = df_410.columns.tolist()
                title_list.remove('plan_id')
                df_tmp.drop(title_list, axis=1, inplace=True)
            elif fc == 210:
                df_tmp = pd.merge(df_tmp, df_210, how='left')
                cond = df_tmp['bill_time'].notnull()
                df_tmp['QG服务费金额2-期收'] = 0
                df_tmp.loc[cond, 'QG服务费金额2-期收'] = np.round(df_tmp.loc[cond, 'qishou_service_fee'], 2)
                df_tmp['每期应还日'] = df_tmp['bill_time']
                df_tmp['应还年'] = df_tmp['bill_year']
                df_tmp['应还月'] = df_tmp['bill_month']
                title_list = df_210.columns.tolist()
                title_list.remove('plan_id')
                df_tmp.drop(title_list, axis=1, inplace=True)
            elif fc == 560:
                df_tmp = pd.merge(df_tmp, df_410, on='plan_id')
                df_tmp['每期应还日'] = df_tmp['bill_time']
                df_tmp['每期应还本金'] = df_tmp['real_principle']
                df_tmp['每期应还利息'] = df_tmp['real_interest']
                df_tmp['QG服务费金额2-期收'] = np.round(df_tmp['real_interest'] * df_tmp['QG向资金方收取的期收费率'], 2)
                df_tmp['应还年'] = df_tmp['bill_year']
                df_tmp['应还月'] = df_tmp['bill_month']
                df_tmp['应还总额'] = df_tmp['ref_amount']
                title_list = df_410.columns.tolist()
                title_list.remove('plan_id')
                df_tmp.drop(title_list, axis=1, inplace=True)
            else:
                df_tmp['QG服务费金额2-期收'] = np.round(df_tmp['qishou_service_fee'], 2)
            qishou_ret.append(df_tmp)

        df_dunshou = pd.concat(dunshou_ret)
        df_qishou = pd.concat(qishou_ret)

        df_qishou_410 = df_qishou[df_qishou.funding_code.isin([410, 490])]
        df_qishou_210 = df_qishou[df_qishou.funding_code == 210]
        df_qishou_520 = df_qishou[df_qishou.funding_code.isin([520, 540, 1000, 580])]

        gp_dunshou = df_dunshou.groupby(
            ['放款年', '放款月', '资金方'])[['放款金额', 'QG服务费金额1-趸收']].agg('sum').reset_index()
        gp_dunshou.to_excel(os.path.join(self.dir_path, '新模式收入确认表-趸收汇总-{}.xlsx'.format(self.start.strftime('%Y%m'))),
                            index=None)

        col_dict = {
            '应还年': '实还年',
            '应还月': '实还月',
            '应还总额': '实还总额',
            '每期应还本金': '当期实还本金',
            '每期应还利息': '当期实还利息',
            '每期应还日': '实还日'
        }

        gp_qishou_410 = df_qishou_410.groupby(['应还年', '应还月', '资金方'])[[
            '应还总额', '每期应还本金', '每期应还利息', 'QG服务费金额2-期收']].agg('sum').reset_index().rename(columns=col_dict)
        gp_qishou_410.to_excel(
            os.path.join(self.dir_path, '新模式收入确认表-期收汇总-渤海-{}.xlsx'.format(self.start.strftime('%Y%m'))), index=None)

        gp_qishou_210 = df_qishou_210.groupby(['应还年', '应还月', '资金方'])[['应还总额', '每期应还本金', '每期应还利息', 'QG服务费金额2-期收']].agg(
            'sum').reset_index().rename(columns={'应还年': '实还年', '应还月': '实还月', })
        gp_qishou_210.to_excel(
            os.path.join(self.dir_path, '新模式收入确认表-期收汇总-广源小贷-{}.xlsx'.format(self.start.strftime('%Y%m'))), index=None)
        # 由于惠金所2的问题,分组加了放款年,放款月
        df_qishou_520 = df_qishou_520.groupby(['放款年', '放款月', '应还年', '应还月', '资金方'])[['应还总额', '每期应还本金', '每期应还利息', 'QG服务费金额2-期收']].agg(
            'sum').reset_index()
        df_qishou_520.to_excel(
            os.path.join(self.dir_path, '新模式收入确认表-期收汇总-惠金所-{}.xlsx'.format(self.start.strftime('%Y%m'))), index=None)

        df_all = pd.concat([df_dunshou, df_qishou])

        df_all['服务费合计'] = df_all['QG服务费金额1-趸收'] + df_all['QG服务费金额2-期收']
        df_all.sort_values(by=['资金方', 'loan_id', 'QG服务费金额2-期收的所属期数'], inplace=True)

        df_all.to_csv(os.path.join(self.dir_path, '新模式收入确认表-明细-{}.csv'.format(self.start.strftime('%Y%m'))), index=None,
                      encoding='gbk')


if __name__ == '__main__':
    new_income_confirm(True).income_confirm_details()
