# -*- coding: utf-8 -*-
import pandas as pd
from sqlalchemy import create_engine
import numpy as np
import datetime
import sys
import os

path = '/Users/chenxiaozhe/Downloads/account/19_01/'
sys.path.append('../../../finance_out_table')
from db_con.db_connect import sql_engine

engine_audit_w = sql_engine('audit_w', 'new_transaction').get_engine()
engine_audit = sql_engine('audit', 'audit').get_engine()


"""
(1)
select merchant_repay_order_no from repay_order where order_id in ()


(2)
select rr.loan_application_history_id as loan_id,rr.repayment_plan_id as plan_id,610,rr.term_no,lamh.loan_paid_at,
rr.principal,rr.interest,rr.premium,rr.actual_repayment as total_amount,'2019-01-23', rr.repayment_plan_id as pay_center_order_no from repayment_record rr
inner join loan_application_manifest_history lamh on lamh.loan_application_history_id=rr.loan_application_history_id

where rr.pay_center_order_no in ()

order by loan_id


(3)
select count(*) from xiaoyingp2p_repay_record_online where created_at>='2019-01-31 14:00:00'

"""





if __name__ == '__main__':
    df_excel = pd.read_excel(path + u"xiaoying-03-29.xlsx", skiprows=1, names=[
        'loan_id',
        'plan_id',
        'fund_id',
        'term_no',
        'loan_paid_at',
        'principle',
        'interest',
        'premium',
        'total_amount',
        'bill_time',
        'pay_center_order_no'
    ], header=None)

    df_excel['loan_id'] = df_excel['loan_id'].astype(str)


    query_sql = """
        select loan_id ,ref_id  from audit.loan_manifest where loan_id in {}
    """
    df_repay_order = pd.read_sql(
        sql=query_sql.format(str(tuple(df_excel.loan_id)).replace(',)', ')')),
        con=engine_audit)

    df_repay_all = pd.merge(df_excel, df_repay_order, how='inner', on='loan_id')
    df_repay_all_610 = df_repay_all.loc[df_repay_all['fund_id'] == 610]
    df_repay_all_610['product_type'] = 1

    df_repay_all_710 = df_repay_all.loc[df_repay_all['fund_id'] == 700]
    df_repay_all_710['product_type'] = 2


    #df_repay_all.to_sql('xiaoyingp2p_repay_record_online', con=engine_audit_w, if_exists='append', index=None)
    print df_repay_all_610
    print df_repay_all_710
