# -*- coding: utf-8 -*-
import sys
import datetime
from out_table.cash_loan.plan_punish import plan_punish
from out_table.cash_loan.repay_split import repay_split

sys.path.append('../../../finance_out_table')


class punish_split():
    def __init__(self, is_mock):
        self.is_mock = is_mock

    def punish_split_detail(self):
        # 罚息计算
        plan_punish(self.is_mock).plan_punish_details(plan_ids=None)
        # 拆分
        today = datetime.date.today()
        end = datetime.date(today.year, today.month, 1)
        last_day = end + datetime.timedelta(days=-1)
        start = datetime.date(last_day.year, last_day.month, 1)

        ##test##
        # start = datetime.date(2018, 8, 1)
        # end = datetime.date(2018, 9, 1)
        ##test##

        split_instance = repay_split(self.is_mock, start, end)
        split_instance.update_repay_ref(plan_ids=None)
        split_instance.update_refund_ref(plan_ids=None)


if __name__ == '__main__':
    punish_split(is_mock=False).punish_split_detail()
