# -*- coding: utf-8 -*-
import os
import sys
import datetime
import pandas as pd

sys.path.append('../../../finance_out_table')
from db_con.db_connect import sql_engine

path = '/home/quant_group/vpants/finance/table/'
new_transaction_conn = sql_engine('audit', 'new_transaction').get_engine()

query_poundage_sql = """
    select r1.pay_approach as '渠道号' ,r2.approach_name as '还款渠道' ,sum(poundage) as '手续费' from repay_record_online r1 inner join repay_channel r2 on r1.pay_approach=r2.id  where r1.bill_time>={} and r1.bill_time<{} group by r1.pay_approach
"""


class month_poundage():
    def __init__(self):
        today = datetime.date.today()
        self.end = datetime.date(today.year, today.month, 1)
        last_day = self.end + datetime.timedelta(days=-1)
        self.start = datetime.date(last_day.year, last_day.month, 1)
        self.dir_path = path + self.start.strftime('%Y%m')
        if not os.path.exists(self.dir_path):
            os.makedirs(self.dir_path)

    def poundage_details(self):
        df = pd.read_sql(sql=query_poundage_sql.format(self.start.strftime("'%Y-%m-%d'"), self.end.strftime("'%Y-%m-%d'")), con=new_transaction_conn)
        df.to_excel(os.path.join(self.dir_path, u'手续费-{}.xlsx'.format(self.start.strftime('%Y%m'))), index=None)


if __name__ == '__main__':
    month_poundage().poundage_details()
