# -*- coding: utf-8 -*-
from apscheduler.schedulers.blocking import BlockingScheduler
from apscheduler.executors.pool import ThreadPoolExecutor, ProcessPoolExecutor
from datetime import datetime
from out_table.cash_loan.guangda_repay import guangda_repay
from out_table.cash_loan.cash_loan_repay import loan_repay
from out_table.cash_loan.old_income_confirm import income_confirm
from out_table.cash_loan.zhongwang2_repay import zhongwang2_repay
from out_table.cash_loan.zhongan_repay import zhongan_repay
from out_table.cash_loan.cash_loan_order import loan_order
from out_table.cash_loan.new_income_confirm import new_income_confirm
from out_table.cash_loan.month_poundage import month_poundage
from out_table.cash_loan.zhongan_loan import zhongan_loan
from out_table.cash_loan.assets_model import asserts
from out_table.cash_loan.bohai_age_of_account import age_of_account
from out_table.cash_loan.bohai_collection_behalf import collection_behalf
from out_table.cash_loan.huijinsuo_repay import huijinsuo_loan_repay
from out_table.cash_loan.xiaoying_repay import xiaoying_repay
from out_table.cash_loan.xingye_loan import xingye_loan
from out_table.cash_loan.xingye_repay import xingye_repay
from out_table.cash_loan.minjin_loan_repay import minjin_loan_repay

executors = {
    'default': ThreadPoolExecutor(25),
    'processpool': ProcessPoolExecutor(12)
}

# 广达客户还款表
def guangda_repay_job():
    print('begin guangda_repay_job :{}'.format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    job_instance = guangda_repay()
    job_instance.yeepay_guangda_repay_details()
    print('end guangda_repay_job :{}'.format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))

# 现金贷客户还款表
def loan_repay_job():
    print('begin loan_repay_job :{}'.format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    job_instance = loan_repay()
    job_instance.loan_repay_details()
    print('end loan_repay_job :{}'.format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))

# 旧模式收入确认表
def old_income_confirm_job():
    print('begin old_income_confirm :{}'.format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    job_instance = income_confirm()
    job_instance.income_confirm_details()
    print('end old_income_confirm :{}'.format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))

# 众网还款
def zhongwang2_repay_job():
    print('begin zhongwang2_repay_job :{}'.format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    job_instance = zhongwang2_repay()
    job_instance.zhongwang2_repay_detail()
    print('end zhongwang2_repay_job :{}'.format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))

# 众安还款
def zhongan_repay_job():
    print('begin zhongan_repay_job :{}'.format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))
    job_instance = zhongan_repay()
    job_instance.zhongan_repay_detail()
    print('end zhongan_repay_job :{}'.format(datetime.now().strftime("%Y-%m-%d %H:%M:%S")))

# 放款表
def loan_order_job():
    job_instance = loan_order()
    job_instance.loan_order_details()

# 新模式收入确认
def new_income_confirm_job():
    job_instance = new_income_confirm(is_mock=False)
    job_instance.income_confirm_details()

# 手续费表
def month_poundage_job():
    job_instance = month_poundage()
    job_instance.poundage_details()

# 众安放款
def zhongan_loan_job():
    job_instance = zhongan_loan(is_mock=False)
    job_instance.zhongan_loan_detail()


# assert
def assert_job():
    job_instance = asserts()
    job_instance.asserts_details()

# 渤海账龄
def bohai_age_job():
    job_instance = age_of_account()
    job_instance.age_of_account_details()


# 渤海催收和代偿
def bohai_collection_behalf_job():
    job_instance = collection_behalf(is_mock=False)
    job_instance.collection_behalf_details()

# 惠金所还款表
def huijinsuo_repay_job():
    job_instance = huijinsuo_loan_repay()
    job_instance.huijinsuo_loan_repay_details()

# 小赢还款
def xiaoying_repay_job():
    job_instance = xiaoying_repay()
    job_instance.xiaoying_repay_detail()

# 兴业放款
def xingye_loan_job():
    job_instance = xingye_loan()
    job_instance.xingye_loan_details()

# 兴业还款
def xingye_repay_job():
    job_instance = xingye_repay()
    job_instance.xingye_repay_details()

# 民金还款
def minjin_loan_repay_job():
    job_instance = minjin_loan_repay()
    job_instance.minjin_loan_repay_detail()


if __name__ == "__main__":
    scheduler = BlockingScheduler(executors=executors)

    scheduler.add_job(guangda_repay_job, 'cron', month='1-12', day='1', hour=13, minute=17, second=0)

    scheduler.add_job(month_poundage_job, 'cron', month='1-12', day='1', hour=13, minute=17, second=0)

    scheduler.add_job(old_income_confirm_job, 'cron', month='1-12', day='1', hour=13, minute=18, second=0)

    scheduler.add_job(loan_repay_job, 'cron', month='1-12', day='1', hour=13, minute=37, second=0)

    scheduler.add_job(zhongwang2_repay_job, 'cron', month='1-12', day='1', hour=13, minute=57, second=0)

    scheduler.add_job(zhongan_repay_job, 'cron', month='1-12', day='1', hour=13, minute=57, second=0)

    scheduler.add_job(zhongan_loan_job, 'cron', month='1-12', day='1', hour=14, minute=5, second=0)

    scheduler.add_job(loan_order_job, 'cron', month='1-12', day='1', hour=14, minute=10, second=0)

    scheduler.add_job(new_income_confirm_job, 'cron', month='1-12', day='1', hour=14, minute=15, second=0)

    scheduler.add_job(huijinsuo_repay_job, 'cron', month='1-12', day='1', hour=14, minute=20, second=0)
    #小赢还款
    scheduler.add_job(xiaoying_repay_job, 'cron', month='1-12', day='1', hour=14, minute=25, second=0)
    #todo 小赢赔付
    #兴业放款
    scheduler.add_job(xingye_loan_job, 'cron', month='1-12', day='1', hour=14, minute=27, second=0)
    #兴业还款
    scheduler.add_job(xingye_repay_job, 'cron', month='1-12', day='1', hour=14, minute=30, second=0)
    #民金还款
    scheduler.add_job(minjin_loan_repay_job, 'cron', month='1-12', day='1', hour=14, minute=32, second=0)

    scheduler.add_job(assert_job, 'cron', month='1-12', day='1', hour=14, minute=35, second=0)

    scheduler.add_job(bohai_age_job, 'cron', month='1-12', day='1', hour=14, minute=45, second=0)

    scheduler.add_job(bohai_collection_behalf_job, 'cron', month='1-12', day='1', hour=14, minute=55, second=0)

    scheduler.start()
