# -*- coding: utf-8 -*-
from apscheduler.schedulers.blocking import BlockingScheduler
from apscheduler.executors.pool import ThreadPoolExecutor, ProcessPoolExecutor
from out_table.cash_loan.punish_split import punish_split

executors = {
    'default': ThreadPoolExecutor(2),
    'processpool': ProcessPoolExecutor(1)
}


def punish_split_job():
    job_instance = punish_split(is_mock=False)
    job_instance.punish_split_detail()


# 用python2 执行
if __name__ == "__main__":
    scheduler = BlockingScheduler(executors=executors)

    scheduler.add_job(punish_split_job, 'cron', month='1-12', day='1', hour=13, minute=30, second=0)

    scheduler.start()
