package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.rest.param.repay.EarlySettleOperateQueryReq;
import cn.quantgroup.customer.rest.param.repay.EarlySettleOperateQueryResp;
import cn.quantgroup.customer.rest.param.repay.EarlySettleOperateReq;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IKoalaService;
import cn.quantgroup.customer.service.http.IHttpService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Slf4j
@Service("koalaService")
public class KoalaServiceImpl implements IKoalaService {

    @Value("${koala.https}")
    private String koalaSysUrl;

    private final IHttpService httpService;

    private final UserSdkImpl userSdk;


    @Autowired
    public KoalaServiceImpl(IHttpService httpService, UserSdkImpl userSdk) {
        this.httpService = httpService;
        this.userSdk = userSdk;
    }


    @Override
    public JsonResult<List<EarlySettleOperateQueryResp>> settleOperateQuery(EarlySettleOperateQueryReq req) {
        JsonResult<List<EarlySettleOperateQueryResp>> jsonResult = null;
        String url = koalaSysUrl + "/v1/repayment/early_settlement/earlySettleOperateQuery";
        Map<String, Object> param = Maps.newHashMap();
        param.put("loanId",req.getLoanId());
        String response = httpService.get(url, param);
        log.info("[KoalaServiceImpl][settleOperateQuery] param:{},请求业务系统返回值:{}", param, response);
        if (StringUtils.isBlank(response)) {
            return JsonResult.buildErrorStateResult("查询失败", null);
        }
        JSONObject jsonObject = JSONObject.parseObject(response);
        if (jsonObject.getBoolean("success")) {
            JSONArray data = jsonObject.getJSONArray("data");
            jsonResult = JsonResult.buildSuccessResult("查询成功",data.toJavaList(EarlySettleOperateQueryResp.class));
        } else {
            jsonResult = JsonResult.buildErrorStateResult(jsonObject.getString("msg"));
        }
        return jsonResult;
    }

    @Override
    public JsonResult<JSONObject> earlySettleOperate(EarlySettleOperateReq req) {
        JsonResult<JSONObject> jsonResult = null;
        String url = koalaSysUrl + "/v1/repayment/early_settlement/simpleCallPay";
        Map<String, Object> param = Maps.newHashMap();
        param.put("loanId",req.getLoanId());
        param.put("cardNo",req.getCardNo());
        param.put("noncestr","ceshikoalanoncestr");
        String response = httpService.post(url, param);
        log.info("[KoalaServiceImpl][earlySettleOperate] param:{},请求业务系统返回值:{}", param, response);
        if (StringUtils.isBlank(response)) {
            return JsonResult.buildErrorStateResult("请求失败", null);
        }
        JSONObject jsonObject = JSONObject.parseObject(response);
        if (jsonObject.getBoolean("success")) {
            jsonResult = JsonResult.buildSuccessResult("已操作",response);
        } else {
            jsonResult = JsonResult.buildErrorStateResult(jsonObject.getString("msg"));
        }
        return jsonResult;
    }
}
