package cn.quantgroup.customer.service.http;

import org.springframework.web.client.RestTemplate;

import java.util.Map;

/**
 * @author mengfan.feng
 * @time 2015-08-13 10:11
 */
public interface IHttpService {

    /**
     * spring web RestTemplate
     *
     * @return
     */
    RestTemplate restTemplate();

    /**
     * Http Get
     *
     * @param uri
     * @return
     */
    String get(String uri);

    <T> T get(String uri, Class<T> clazz);

    /**
     * Http Get
     *
     * @param uri
     * @param parameters
     * @return
     */
    String get(String uri, Map<String, ?> parameters);

    /**
     * Http Get
     *
     * @param uri
     * @param headers
     * @param parameters
     * @return
     */
    String get(String uri, Map<String, String> headers, Map<String, ?> parameters);

    /**
     * Http Get 获取byte[]
     * @param uri
     * @param headers
     * @param parameters
     * @return
     */
    byte[] getByte(String uri, Map<String, String> headers, Map<String, ?> parameters);

    /**
     * Http Post
     *
     * @param uri
     * @return
     */
    String post(String uri);

    /**
     * Http Post
     *
     * @param uri
     * @param parameters
     * @return
     */
    String post(String uri, Object parameters);

    String post(String uri, Map<String, ?> parameters);

    <T> T post(String uri, Map<String, String> headers, Object parameters, Class<T> clazz);

    <T> T postWithParam(String uri, Map<String, String> parameters, Class<T> clazz);


    <T> T post(String uri, Map<String, String> headers, Map<String, String> parameters, Class<T> clazz);

    /**
     * Http Post
     *
     * @param uri
     * @param headers
     * @param parameters
     * @return
     */
    String post(String uri, Map<String, String> headers, Object parameters);


    <T> T put(String uri, final Map<String, String> headers, Object parameters, Class<T> clazz);
}
