package cn.quantgroup.customer.service.impl;

import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;


@Service
@Slf4j
public class UserSdkImpl {

    @Autowired
    @Qualifier("httpClient")
    private CloseableHttpClient httpClient;

    @Value("${passportapi.http}")
    private String passportapiHttp;

    private IUserSdkService userSdkService;

    @PostConstruct
    private void init() {
        userSdkService = UserSdkServiceFactory.generateSDKService(passportapiHttp, httpClient);
    }

    public IUserSdkService getService() {
        return userSdkService;
    }

}
