package cn.quantgroup.customer.entity;

import lombok.*;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * @author yangjun
 * @Date 2020/4/13 17:37
 * @Desc
 * @Update
 */
@Entity
@Table(name = "operate_log")
@ToString
@Builder
@Getter
@Setter
@AllArgsConstructor
public class OperateLogModel {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "user_no")
    private String userNo;

    @Column(name = "user_name")
    private String userName;

    @Column(name = "module")
    private String module;

    @Column(name = "module_name")
    private String moduleName;

    @Column(name = "request")
    private String request;

    @Column(name = "response")
    private String response;

    @Column(name = "loan_id")
    private Long loanId;

    @Column(name = "apply_no")
    private String applyNo;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "remark")
    private String remark;

    @Column(name = "status")
    private Integer status;

    public OperateLogModel() {
    }

}
