package cn.quantgroup.customer.config.mail;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

import java.util.Properties;

/**
 * @author jie.feng
 */
@Configuration
public class MailConfig {

    @Value("${customer.transaction.mail.from}")
    private String username;
    @Value("${customer.transaction.mail.host}")
    private String host;
    @Value("${customer.transaction.mail.port}")
    private int port = 587;
    @Value("${customer.transaction.mail.password}")
    private String password;

    @Bean(name = "monitorMailSender")
    public JavaMailSender getSender() {
        JavaMailSenderImpl javaMailSender = new JavaMailSenderImpl();
        javaMailSender.setUsername(username);
        javaMailSender.setHost(host);
        javaMailSender.setPort(port);
        javaMailSender.setDefaultEncoding("UTF-8");
        javaMailSender.setPassword(password);
        //Properties prop = new Properties();
        //prop.put("mail.smtp.auth", "true");
        //prop.put("mail.smtp.timeout", "25000");
        //prop.setProperty("mail.smtp.port", Integer.toString(port));
        //设置ssl端口
        //prop.setProperty("mail.smtp.socketFactory.port", Integer.toString(port));
        //prop.setProperty("mail.smtp.socketFactory.fallback", "false");
        //prop.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        //javaMailSender.setJavaMailProperties(prop);
        return javaMailSender;
    }
}