package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.entity.WorkOrder;
import cn.quantgroup.customer.model.workorder.WorkOrderVO;
import cn.quantgroup.customer.model.workorder.WorkOrderStatus;
import cn.quantgroup.customer.repo.WorkOrderRepo;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IWorkOrderService;
import cn.quantgroup.customer.util.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @description:
 * @author:tao
 * @create: 2020-08-14 15:24
 */
@Slf4j
@Service
public class WorkOrderServiceImpl implements IWorkOrderService {

    @Autowired
    private WorkOrderRepo workOrderRepo;

    @Override
    public JsonResult<Page<WorkOrderVO>> queryWorkOrder(Integer pageNumber, Integer pageSize, String phone, WorkOrderStatus status) {
        Page<WorkOrder> page = workOrderRepo.findAll((root, criteriaQuery, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();
            //
            if (Objects.nonNull(status)) {
                predicates.add(criteriaBuilder.equal(root.get("status"), status.ordinal()));
            }
            if (StringUtils.isNotEmpty(phone)) {
                predicates.add(criteriaBuilder.equal(root.get("phone"), phone));
            }

            // 设置查询条件
            criteriaQuery.where(criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()])));
            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));

            return criteriaQuery.getRestriction();

        }, new PageRequest(pageNumber, pageSize));

        Page<WorkOrderVO> map = page.map(it -> {
            WorkOrderVO workOrderVO = new WorkOrderVO();
            workOrderVO.setWorkOrderId(it.getWorkOrderId() != null ? it.getWorkOrderId()+"" : null);
            workOrderVO.setUserName(it.getUserName());
            workOrderVO.setPhone(it.getPhone());
            workOrderVO.setSubject(it.getSubject());
            workOrderVO.setFrom(it.getFrom());
            workOrderVO.setType1(it.getType1());
            workOrderVO.setType2(it.getType2());
            workOrderVO.setType3(it.getType3());
            workOrderVO.setPriority(it.getPriority() != null ? it.getPriority().getDesc() : "");
            workOrderVO.setStatus(it.getStatus().getDesc());
            workOrderVO.setCreateUsername(it.getCreateUsername());
            workOrderVO.setOpUsername(it.getOpUsername());
            workOrderVO.setDurationTimes(it.getDurationTimes() != null ? it.getDurationTimes()+"" : null);
            workOrderVO.setDuration(it.getDuration() != null ? it.getDuration()+"" : null);
            workOrderVO.setCreatedAt(it.getCreatedAt() == null ? "" : DateUtil.format(it.getCreatedAt(), DateUtil.DATE_FORMAT_1));
            workOrderVO.setOpAt(it.getOpAt() == null ? "" : DateUtil.format(it.getOpAt(), DateUtil.DATE_FORMAT_1));
            workOrderVO.setUpdatedAt(it.getUpdatedAt() == null ? "" : DateUtil.format(it.getUpdatedAt(), DateUtil.DATE_FORMAT_1));
            workOrderVO.setRemark(it.getRemark());
            return workOrderVO;
        });
        if (map != null) {
            return JsonResult.buildSuccessResult("success", map);
        } else {
            return JsonResult.buildErrorStateResult("查询失败");
        }
    }
}
