package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.enums.ErrorCodeEnum;
import cn.quantgroup.customer.rest.param.card.ModifyCardsQuery;
import cn.quantgroup.customer.rest.param.card.ModifyReservePhone;
import cn.quantgroup.customer.rest.param.card.UnBindCardModel;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.card.CardResult;
import cn.quantgroup.customer.rest.vo.card.XyqbCardRelationResult;
import cn.quantgroup.customer.rest.vo.card.XyqbCardsResult;
import cn.quantgroup.customer.service.ICardService;
import cn.quantgroup.customer.service.IXyqbService;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author yangjun
 * @Date 2020/3/9 10:52
 * @Desc
 * @Update
 */
@Slf4j
@Service("cardService")
public class CardServiceImpl implements ICardService {
    @Autowired
    private IXyqbService xyqbService;


    @Override
    public JsonResult queryCardLists(ModifyCardsQuery cardsQuery) {
        if (Objects.isNull(cardsQuery)) {
            log.error("请求参数 cardsQuery 为空");
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.PARAM_ERROR.getMessage(), ErrorCodeEnum.PARAM_ERROR.getCode());
        }


        if (StringUtils.isBlank(cardsQuery.getPhoneNo()) && Objects.isNull(cardsQuery.getUserId())) {
            log.error("请求参数 phoneNo 和 userId 不能同时为空");
            return JsonResult.buildErrorStateResult("phoneNo 和 userId 不能同时为空", ErrorCodeEnum.RETURN_ERROR.getCode());
        }

        Long userId = cardsQuery.getUserId();
        if (Objects.isNull(userId)) {
            // TODO 需要根据手机号查询用户userId
            userId = null;
        }

        //发起xyqb查询
        String cardXyqbStr = xyqbService.queryCardLists(userId);
        log.info("[查询xyqb返回绑卡信息],cardXyqbStr={}", cardXyqbStr);
        if (StringUtils.isBlank(cardXyqbStr)) {
            log.error("[查询xyqb返回绑卡信息],返回结果为null");
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.RETURN_ERROR.getMessage(), ErrorCodeEnum.RETURN_ERROR.getCode());
        }

        XyqbCardsResult xyqbCardsResult = null;
        try {
            xyqbCardsResult = JSONObject.parseObject(cardXyqbStr, XyqbCardsResult.class);
        } catch (Exception e) {
            log.error("[绑卡信息转换异常]", e);
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.RETURN_ERROR.getMessage(), ErrorCodeEnum.RETURN_ERROR.getCode());
        }

        if (!xyqbCardsResult.isSucc()) {
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.RETURN_ERROR.getMessage(), ErrorCodeEnum.RETURN_ERROR.getCode());
        }

        CardResult cardResult = new CardResult();
        cardResult.setBindCardInfo(xyqbCardsResult.getData());

        log.info("[查询绑卡信息]，返回 cardResult={}", cardResult);
        return JsonResult.buildSuccessResult("处理成功", cardResult);
    }


    /**
     * 查询卡关联信息
     *
     * @param bankId
     * @return
     */
    @Override
    public JsonResult queryCardRelation(Long bankId) {
        if (Objects.isNull(bankId)) {
            log.error("请求参数 bankId 为空");
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.PARAM_ERROR.getMessage(), ErrorCodeEnum.PARAM_ERROR.getCode());
        }

        //发起xyqb查询
        String cardRelationStr = xyqbService.queryCardRelation(bankId);
        log.info("[查询xyqb返回卡关联信息],cardRelationStr={}", cardRelationStr);
        if (StringUtils.isBlank(cardRelationStr)) {
            log.error("[查询xyqb返回卡关联信息],返回结果为null");
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.RETURN_ERROR.getMessage(), ErrorCodeEnum.RETURN_ERROR.getCode());
        }

        XyqbCardRelationResult xyqbCardRelationResult = null;
        try {
            xyqbCardRelationResult = JSONObject.parseObject(cardRelationStr, XyqbCardRelationResult.class);
        } catch (Exception e) {
            log.error("[卡关联信息转换异常]", e);
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.RETURN_ERROR.getMessage(), ErrorCodeEnum.RETURN_ERROR.getCode());
        }

        if (!xyqbCardRelationResult.isSucc()) {
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.RETURN_ERROR.getMessage(), ErrorCodeEnum.RETURN_ERROR.getCode());
        }

        log.info("[查询卡关联信息]，返回 data={}", xyqbCardRelationResult.getData());
        return JsonResult.buildSuccessResult("处理成功", xyqbCardRelationResult.getData());
    }

    @Override
    public JsonResult unBindCardRelation(UnBindCardModel unBindCardModel) {
        if (Objects.isNull(unBindCardModel)) {
            log.error("请求参数 unBindCardModel 为空");
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.PARAM_ERROR.getMessage(), ErrorCodeEnum.PARAM_ERROR.getCode());
        }


        if (Objects.isNull(unBindCardModel.getBindCardRecordId()) || Objects.isNull(unBindCardModel.getUserId())) {
            log.error("请求参数 bindCardRecordId 和 userId 不能为空");
            return JsonResult.buildErrorStateResult("bindCardRecordId 和 userId 不能为空", ErrorCodeEnum.RETURN_ERROR.getCode());
        }

        //发起xyqb查询
        String unBindCardStr = xyqbService.unBindCardRelation(unBindCardModel);
        log.info("[解除绑卡信息],unBindCardStr={}", unBindCardStr);
        if (StringUtils.isBlank(unBindCardStr)) {
            log.error("[查询xyqb返回绑卡信息],返回结果为null");
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.RETURN_ERROR.getMessage(), ErrorCodeEnum.RETURN_ERROR.getCode());
        }

        log.info("[解除绑卡信息]，返回 cardResult={}", 123);
        return JsonResult.buildSuccessResult("处理成功", "");
    }

    @Override
    public JsonResult modifyReservePhone(ModifyReservePhone modifyReservePhone) {
        if (Objects.isNull(modifyReservePhone)) {
            log.error("请求参数 modifyReservePhone 为空");
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.PARAM_ERROR.getMessage(), ErrorCodeEnum.PARAM_ERROR.getCode());
        }


        if (Objects.isNull(modifyReservePhone.getBankId())
                || Objects.isNull(modifyReservePhone.getUserId())
                || StringUtils.isBlank(modifyReservePhone.getPhoneNo())) {
            log.error("请求参数 bankId,userId,phoneNo 都不能为空");
            return JsonResult.buildErrorStateResult("bankId,userId,phoneNo 不能为空", ErrorCodeEnum.RETURN_ERROR.getCode());
        }

        //发起xyqb查询
        String modifyReservePhoneStr = xyqbService.modifyReservePhone(modifyReservePhone);
        log.info("[调用xyqb，修改预留手机号],modifyReservePhoneStr={}", modifyReservePhoneStr);
        if (StringUtils.isBlank(modifyReservePhoneStr)) {
            log.error("[调用xyqb，修改预留手机号],返回结果为null");
            return JsonResult.buildErrorStateResult(ErrorCodeEnum.RETURN_ERROR.getMessage(), ErrorCodeEnum.RETURN_ERROR.getCode());
        }

        log.info("[修改预留手机号]，返回 cardResult={}", 123);
        return JsonResult.buildSuccessResult("处理成功", "");
    }


}
