package cn.quantgroup.customer.entity;

import lombok.*;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

@Entity
@Table(name = "offline_repay_operate_record")
@ToString
@Builder
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@DynamicUpdate
@DynamicInsert
public class OfflineRepayOperateRecord implements Serializable {

    private static final long serialVersionUID = -9206318459421433518L;
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "serial_no")
    private String serialNo;
    @Column(name = "operate_account")
    private String operateAccount;
    @Column(name = "operate_name")
    private String operateName;
    @Column(name = "operate_content")
    private String operateContent;
    @Column(name = "operate_time")
    private Date operateTime;
    @Column(name = "remark")
    private String remark;
    @Column(name = "create_time")
    @CreatedDate
    private Date createTime;
    @Column(name = "update_time")
    @LastModifiedDate
    private Date updateTime;
}
