package cn.quantgroup.customer.enums;


import java.util.Arrays;
import java.util.Optional;

/**
 * Created by Administrator on 2019/12/17.
 */
public enum OrderStatusEnums {
    CREDIT_SUCC("CREDIT_SUCC","授信成功"),
    APPROVE_ING("APPROVE_ING","审批中"),
    FUAD_ASSIFN_SUCC("FUAD_ASSIFN_SUCC","分配资金方成功"),
    REJECT("REJECT","风控审核不通过"),
    WITHDRAW("WITHDRAW","用户提现申请成功"),
    WITHDRAW_APPROVING("WITHDRAW_APPROVING","提现审批中"), // 对应loan状态50等待二次审核
    PAY_ING("PAY_ING","放款中"),
    FUND_SUCC("FUND_SUCC","放款成功"),
    FUND_WAITING_WITHDRAW("FUND_WAITING_WITHDRAW","放款成功,等待二次提现"),
    FUND_WITHDRAW_SUCC("FUND_WITHDRAW_SUCC","放款提现成功,存管提现成功"),
    FUND_FAIL("FUND_FAIL","放款失败"),
    ALL_REPAID("ALL_REPAID","结清"),
    CANCEL_LOAN("CANCEL_LOAN","贷前关闭订单"),
    CANCEL_AFTER_LOAN("CANCEL_AFTER_LOAN","贷后关闭订单");

    private String key;
    private String value;


    OrderStatusEnums(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public static String getValue(String key){
        Optional<OrderStatusEnums> optional =Arrays.asList(OrderStatusEnums.values()).stream().filter(coreStatus -> key.equalsIgnoreCase(coreStatus.getKey())).findFirst();
        if(optional.isPresent()){
            return optional.get().getValue();
        }
        return OrderStatusEnums.APPROVE_ING.getValue();
    }
    public static boolean finalStatus (OrderStatusEnums enums) {
        switch (enums) {
            case REJECT:
            case FUND_FAIL:
            case ALL_REPAID:
            case CANCEL_LOAN:
            case CANCEL_AFTER_LOAN: return true;
            default:return false;
        }
    }
}
