package cn.quantgroup.customer.service;

import cn.quantgroup.customer.model.xyqbuser.UserBasicInfo;
import cn.quantgroup.customer.rest.param.ordermapping.OrderQueryParam;
import cn.quantgroup.customer.rest.param.phone.ModifyPhoneAudit;
import cn.quantgroup.customer.rest.param.phone.ModifyPhoneFeedback;
import cn.quantgroup.customer.rest.param.phone.ModifyPhoneQuery;
import cn.quantgroup.customer.rest.param.user.UserCombinationParam;
import cn.quantgroup.customer.rest.param.user.UserQueryParam;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.MoResult;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;

@Service
public interface IUserService extends UserDetailsService {

    String modifyPhoneQuery(ModifyPhoneQuery modifyPhoneQuery);

    String modifyPhoneAudit(ModifyPhoneAudit modifyPhoneAudit);

    String deleteToken(ModifyPhoneAudit modifyPhoneAudit);

    String modifyPhoneFeedback(ModifyPhoneFeedback modifyPhoneFeedback);

    String findUuidByIdNo(String idNo);


    /**
     * 用户基本信息
     *
     * @param userQueryParam
     * @return
     */
    JsonResult<UserBasicInfo> findUserInfo(UserQueryParam userQueryParam);

    JsonResult<UserBasicInfo> findUserInfoByOrderParam(OrderQueryParam orderQueryParam);

    JsonResult findUserCombination(UserCombinationParam userCombinationParam);

    /**
     * 重置用户密码
     * @param phoneNo
     * @return
     */
    MoResult<String> passwordRest(String phoneNo);

    /**
     * 注销账户
     * @param userId
     * @return
     */
    MoResult<Boolean> modifyAccountStatusDisable(Long userId);

    /**
     * 激活账户
     * @param userId
     * @return
     */
    MoResult<Boolean> modifyAccountStatusActive(Long userId);

    /**
     * 修改用户姓名、身份证
     * @param userId
     * @param realName
     * @param idNO
     * @return
     */
    MoResult<String> modifyUserDetail(Long userId, String realName, String idNO);

}
