package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.model.order.OrderRepayment;
import cn.quantgroup.customer.rest.param.repay.RepayOrderInfoQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.rest.vo.MoResult;
import cn.quantgroup.customer.service.ISidecarService;
import cn.quantgroup.customer.service.http.IHttpService;
import cn.quantgroup.customer.util.JSONTools;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Slf4j
@Service("sidecarService")
public class SidecarServiceImpl implements ISidecarService {

    @Value("${mo-sidecar.http}")
    private String sidecarUrl;

    private final IHttpService httpService;


    @Autowired
    public SidecarServiceImpl(IHttpService httpService) {
        this.httpService = httpService;
    }


    @Override
    public JsonResult<OrderRepayment> repaymentPlanQuery(Long loanId) {
        String logPre = "sidecarService.repaymentPlanQuery";
        log.info("{} 查询还款计划loanId={}", logPre, loanId);
        String url = sidecarUrl + "/middle_office/repayment/plan_view";
        Map<String, String> queryParam = new HashMap<>(2);
        queryParam.put("loanId", loanId.toString());
        String result = httpService.get(url, queryParam);
        if (StringUtils.isBlank(result)) {
            log.error("{} 查询还款计划失败 loanId={} result={}", logPre, loanId, result);
            return JsonResult.buildErrorStateResult("查询还款计划失败", null);
        } else {
            MoResult<OrderRepayment> orderRepaymentResult = JSONTools.deserialize(result, new TypeReference<MoResult<OrderRepayment>>() {
            });
            if (orderRepaymentResult != null) {
                if(orderRepaymentResult.isSuccess()){
                    return JsonResult.buildSuccessResult("success",orderRepaymentResult.getData());
                }else {
                    return JsonResult.buildErrorStateResult(orderRepaymentResult.getMsg());
                }
            } else {
                return JsonResult.buildErrorStateResult("还款计划查询失败");
            }
        }
    }

    @Override
    public String queryRepayInfo(RepayOrderInfoQuery repayOrderQuery) {
        String url = sidecarUrl + "/middle_office/repayment/plan_info";
        Map<String, Object> param = new HashMap<>(4);
        Long loanId = repayOrderQuery.getLoanId();
        Integer termNo = repayOrderQuery.getTermNo();
        if (Objects.nonNull(loanId)) {
            param.put("loanId", loanId);
        }
        if (Objects.nonNull(termNo)) {
            param.put("termNo", termNo);
        }

        String response = null;
        try {
            response = httpService.post(url, param);
            log.info("[queryRepayInfo] param:{},请求业务系统返回值:{}", param, response);
        } catch (Exception e) {
            log.error("[queryRepayInfo] param:{},请求业务系统异常:{}", param, e);
        }
        return response;
    }


    @Override
    public String queryRepayOptRecords(String businessFlowNo) {
        String url = sidecarUrl + "/middle_office/repayment/repay_result";
        Map<String, Object> param = new HashMap<>(4);
        if (StringUtils.isNotBlank(businessFlowNo)) {
            param.put("businessFlowNo", businessFlowNo);
        }

        String response = null;
        try {
            response = httpService.post(url, param);
            log.info("[queryRepayOptRecords] param:{},请求业务系统返回值:{}", param, response);
        } catch (Exception e) {
            log.error("[queryRepayOptRecords] param:{},请求业务系统异常:{}", param, e);
        }
        return response;
    }
}
