package cn.quantgroup.customer.service.impl;

import cn.quantgroup.customer.model.order.ApplyOrder;
import cn.quantgroup.customer.rest.param.applyorder.ApplyOrderQuery;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IIceService;
import cn.quantgroup.customer.service.http.IHttpService;
import cn.quantgroup.customer.util.JSONTools;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

@Slf4j
@Service("iceService")
public class IceServiceImpl implements IIceService {

    @Value("${mo.ice.http}")
    private String iceUrl;

    private final IHttpService httpService;


    @Autowired
    public IceServiceImpl(IHttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public JsonResult<ApplyOrder> findApplyOrders(ApplyOrderQuery applyOrderQuery) {
        String logPre = "IceService.findApplyOrders";
        log.info("{} 申请订单查询 applyOrderQuery={}", logPre, applyOrderQuery);
        String orderNo = applyOrderQuery.getOrderNo();
        Long loanId = applyOrderQuery.getLoanId();
        Long userId = applyOrderQuery.getUserId();
        String url = iceUrl + "/ex/customer_sys/query/applyOrder";
        Map<String, Object> param = Maps.newHashMap();
        if (StringUtils.isNotEmpty(orderNo)) {
            param.put("orderNo", orderNo);
        }
        if (Objects.nonNull(userId)) {
            param.put("userId", userId.toString());
        }
        if (Objects.nonNull(loanId)) {
            param.put("loanId", loanId.toString());
        }
        Map<String, String> header = Maps.newHashMap();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String result = httpService.post(url, header, param);
        log.info("{} 用户申请订单列表 url={}, header={},param={},result={}", logPre, url, header, param, result);
        if (StringUtils.isBlank(result)) {
            log.error("{} 调用信用钱包失败 url={}, header={},param={},result={}", logPre, url, header, param, result);
            return JsonResult.buildErrorStateResult("申请订单查询失败", null);
        }

        TypeReference<JsonResult<ApplyOrder>> typeToken = new TypeReference<JsonResult<ApplyOrder>>() {
        };
        JsonResult<ApplyOrder> jsonResult = JSONTools.deserialize(result, typeToken);
        return jsonResult;
    }
}
