package cn.quantgroup.customer.moice.vo;
import cn.quantgroup.customer.util.MoneySerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wuq
 * @since 2021-11-29
 */
@Data
public class LoanOrderVo extends ApplyOrderVO {
    /**
     * 借款状态
     */
    private String loanStatus = StatusMap.DEFAULT_STATUS;
    /**
     * 借款金额
     */
    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal amount;
    /**
     * 放款时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date paidAt;
    /**
     * 每期应还金额
     */
    @JsonSerialize(using = MoneySerializer.class)
    private BigDecimal termRepayment;
}
