package cn.quantgroup.customer.moice.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;


/**
 *用户提现信息查询
 * @author wuq
 * @date 2021-11-29
 */
@Data
public class ApplyOrderVO implements Serializable {
    private static final long serialVersionUID = -1L;

    /** 序号 */
    private Integer num;

    /** 渠道订单号 */
    private String channelNo = StringUtils.EMPTY;

    /** 用户 id */
    private Long userId;

    /** 申请订单号 */
    private String applyOrderNo;

    /** 审核状态 */
    private String applyStatus;

    /** 申请时间 */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyAt;

    /** 订单类型描述 */
    private String productDesc;

    /** 渠道名称 */
    private String channelName;

    /** 分配资金方记录ID（关单使用参数） */
    private Long assignFundingRecordId;

    /**
     * 客服系统 控制查看提现订单按钮是否可用
     */
    private boolean showBtn = false;
    //客服系统 查看提现订单展示使用
    private Long loanId;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateAt;

    private String remark;

}
