package cn.quantgroup.customer.moice.model;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * 这里是数据库中的资金方配置
 * 类名称：FundingCorp
 * 类描述：
 * @author Feng
 */
@Entity
@Getter
@Setter
@ToString
@EqualsAndHashCode
@Table(name = "funding_corp")
public class FundingCorpEntity implements Serializable{

    private static final long serialVersionUID = -2499529693692896987L;

    @Id
    @Column(name = "id")
    private Long id;

    @Column(name = "name")
    private String name;
    @Column(name = "description")
    private String description;
    @Column(name = "strategy_name")
    private String strategyName;
    @Column(name = "monthly_interest_rate")
    private BigDecimal monthlyInterestRate;
    @Column(name = "repayment_rule_name")
    private String repaymentRuleName;
    @Column(name = "created_at")
    private Timestamp createdAt;
    @Column(name = "updated_at")
    private Timestamp updatedAt;
    @Column(name = "is_enable")
    private boolean enable;
    @Column(name = "is_show")
    private boolean show;

    @Column(name = "max_order")
    private int maxOrder = 1;

    @Column(name = "loan_merchant_id")
    private Integer loanMerchantId;

    @Column(name = "support_quota")
    private boolean supportQuota = false;

}
