package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.constant.Constant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@Slf4j
@ControllerAdvice(annotations = {RestController.class, Controller.class})
public class RestAdvice {

    @ExceptionHandler({BadCredentialsException.class})
    @ResponseBody
    @ResponseStatus(HttpStatus.OK)
    public JsonResult handleBadCredentialsException(BadCredentialsException ex) {
        log.info(ex.getMessage());
        return JsonResult.buildErrorStateResult(Constant.NAME_OR_PWD_ERROR, null);
    }

}
