package cn.quantgroup.customer.enums;

public enum ApprovalStatus {

    APPROVAL_PROCESSING(0,"审批中"),
    APPROVAL_PASS(1,"审批通过"),
    APPROVAL_REFUSE(2,"审批拒绝");

    private Integer code;
    private String desc;

    ApprovalStatus(Integer code,String desc){
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByValue(Integer value){
        for (ApprovalStatus approvalStatus:ApprovalStatus.values()){
            if (approvalStatus.code.equals(value)){
                return approvalStatus.desc;
            }
        }
        return "";
    }
}
