package cn.quantgroup.customer.service;

import cn.quantgroup.customer.entity.Authority;
import cn.quantgroup.customer.entity.RoleAuthority;
import cn.quantgroup.customer.entity.UserRole;
import cn.quantgroup.customer.rest.param.ModifyPhoneAudit;
import cn.quantgroup.customer.rest.param.ModifyPhoneFeedback;
import cn.quantgroup.customer.rest.param.ModifyPhoneQuery;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public interface IUserService extends UserDetailsService {
    List<UserRole> findUserRoleByUserId(Long userId);

    List<RoleAuthority> findRoleAuthorityByRoleIds(List<Long> roleIdList);

    List<Authority> findAuthorityByAuthorityIds(List<Long> authorityIdList);

    String modifyPhoneQuery(ModifyPhoneQuery modifyPhoneQuery);

    String modifyPhoneAudit(ModifyPhoneAudit modifyPhoneAudit);

    String modifyPhoneFeedback(ModifyPhoneFeedback modifyPhoneFeedback);
}
