package cn.quantgroup.customer.rest.vo;

import cn.quantgroup.customer.entity.User;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.security.core.GrantedAuthority;

import java.util.List;
import java.util.stream.Collectors;

@Getter
@Setter
@Builder
public class AuthUserVo {
    private String username;
    private List<String> authorities;

    public static AuthUserVo parse(User user) {
        AuthUserVo.AuthUserVoBuilder builder = AuthUserVo.builder();
        builder.username(user.getUsername());
        if (CollectionUtils.isNotEmpty(user.getAuthorities())) {
            List<String> authorityList = user.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
            builder.authorities(authorityList);
        }
        return builder.build();
    }
}
