package cn.quantgroup.customer.util.poi;


import cn.quantgroup.customer.model.workorder.WorkOrderVO;
import cn.quantgroup.customer.util.JSONTools;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author y
 * @create 2018-01-19 0:13
 * @desc
 **/
public class ReaderTest implements Reader {


    private final static String filePath = "/Users/simon/Downloads/1.xlsx";
//    private final static String filePath = "/Users/simon/Downloads/work_order_created.xlsx";

    private WorkOrderVO workOrderVO = null;

    @Getter
    private List<WorkOrderVO> list = new ArrayList<>();


    public void read() throws Exception {
        long start = System.currentTimeMillis();
        XlsxReader excelXlsxReader = new XlsxReader(this);
        int totalRows = excelXlsxReader.process(filePath);

        System.out.println("总行数：" + totalRows +",耗时:" + (System.currentTimeMillis() - start));
        System.out.println(JSONTools.serialize(list.get(0)));
        System.out.println(JSONTools.serialize(list.get(list.size()-1)));
    }

    @Override
    public void read(String filePath, String sheetName, int sheetIndex, int curRow, List<String> cellList) {
        workOrderVO = new WorkOrderVO();
        workOrderVO.setWorkOrderId(cellList.get(0));
        workOrderVO.setDurationTimes(cellList.get(1));
        workOrderVO.setUserName(cellList.get(2));
        workOrderVO.setPhone(cellList.get(3));
        workOrderVO.setSubject(cellList.get(4));
        workOrderVO.setFrom(cellList.get(5));
        workOrderVO.setType1(cellList.get(6));
        workOrderVO.setType2(cellList.get(7));
        workOrderVO.setType3(cellList.get(8));
        workOrderVO.setPriority(cellList.get(9));
        workOrderVO.setCreateUsername(cellList.get(10));
        workOrderVO.setCreatedAt(cellList.get(11));
        workOrderVO.setOpUsername(cellList.get(12));
        workOrderVO.setDuration(cellList.get(13));
        workOrderVO.setStatus(cellList.get(14));
        workOrderVO.setOpAt(cellList.get(15));
        workOrderVO.setRemark(cellList.get(16));
        list.add(workOrderVO);
    }
}

