package cn.quantgroup.customer.rest;

import cn.quantgroup.customer.model.workorder.WorkOrderStatus;
import cn.quantgroup.customer.rest.vo.JsonResult;
import cn.quantgroup.customer.service.IWorkOrderService;
import cn.quantgroup.customer.util.poi.ReaderTest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;

/**
 * @description: 工单查询
 * @Author:tao
 * @create: 2020-08-13 15:57
 */
@Slf4j
@RestController
@RequestMapping("work_order")
public class WorkOrderRest {

    @Autowired
    private IWorkOrderService workOrderService;

    @GetMapping("query_page")
    public JsonResult queryPage(Integer pageNumber, Integer pageSize, String phone, String status) {
        WorkOrderStatus statusEnum;
        try {
            statusEnum = WorkOrderStatus.valueOf(status);
        } catch (IllegalArgumentException e) {
            log.error("[workOrderRest_queryPage]查询参数status错误，status={}, e={}", status, ExceptionUtils.getStackTrace(e));
            return JsonResult.buildErrorStateResult("查询参数status错误");
        }
        return workOrderService.queryWorkOrder(pageNumber, pageSize, phone, statusEnum);
    }





    @GetMapping("upload")
    public JsonResult upload() throws Exception {

        ReaderTest readerTest = new ReaderTest();
        readerTest.read();
        workOrderService.importData(readerTest.getList());
        return JsonResult.buildSuccessResult("success", null);
    }


    public static void main(String[] args) throws IOException {
    }
}
